/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.confignode.procedure;

import java.util.Iterator;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import org.apache.iotdb.confignode.procedure.CompletedProcedureContainer;
import org.apache.iotdb.confignode.procedure.InternalProcedure;
import org.apache.iotdb.confignode.procedure.Procedure;
import org.apache.iotdb.confignode.procedure.store.IProcedureStore;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CompletedProcedureRecycler<Env>
extends InternalProcedure<Env> {
    private static final Logger LOG = LoggerFactory.getLogger(CompletedProcedureRecycler.class);
    private static final int DEFAULT_BATCH_SIZE = 32;
    private long evictTTL;
    private final Map<Long, CompletedProcedureContainer<Env>> completed;
    private final IProcedureStore store;

    public CompletedProcedureRecycler(IProcedureStore store, Map<Long, CompletedProcedureContainer<Env>> completedMap, long cleanTimeInterval, long evictTTL) {
        super(TimeUnit.SECONDS.toMillis(cleanTimeInterval));
        this.completed = completedMap;
        this.store = store;
        this.evictTTL = evictTTL;
    }

    @Override
    protected void periodicExecute(Env env) {
        if (this.completed.isEmpty()) {
            if (LOG.isTraceEnabled()) {
                LOG.trace("No completed procedures to cleanup.");
            }
            return;
        }
        long[] batchIds = new long[32];
        int batchCount = 0;
        long now = System.currentTimeMillis();
        Iterator<Map.Entry<Long, CompletedProcedureContainer<Env>>> it = this.completed.entrySet().iterator();
        while (it.hasNext() && this.store.isRunning()) {
            Map.Entry<Long, CompletedProcedureContainer<Env>> entry = it.next();
            CompletedProcedureContainer<Env> retainer = entry.getValue();
            Procedure<Env> proc = retainer.getProcedure();
            if (!retainer.isExpired(now, this.evictTTL)) continue;
            batchIds[batchCount++] = entry.getKey();
            if (batchCount == batchIds.length) {
                this.store.delete(batchIds, 0, batchCount);
                batchCount = 0;
            }
            it.remove();
            LOG.trace("Evict completed {}", proc);
        }
        if (batchCount > 0) {
            this.store.delete(batchIds, 0, batchCount);
        }
    }
}

