/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.confignode.persistence.executor;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.stream.Collectors;
import org.apache.iotdb.common.rpc.thrift.TSStatus;
import org.apache.iotdb.commons.auth.AuthException;
import org.apache.iotdb.commons.path.PartialPath;
import org.apache.iotdb.commons.snapshot.SnapshotProcessor;
import org.apache.iotdb.confignode.consensus.request.ConfigRequest;
import org.apache.iotdb.confignode.consensus.request.auth.AuthorReq;
import org.apache.iotdb.confignode.consensus.request.read.CountStorageGroupReq;
import org.apache.iotdb.confignode.consensus.request.read.GetDataNodeInfoReq;
import org.apache.iotdb.confignode.consensus.request.read.GetDataPartitionReq;
import org.apache.iotdb.confignode.consensus.request.read.GetNodePathsPartitionReq;
import org.apache.iotdb.confignode.consensus.request.read.GetRegionInfoListReq;
import org.apache.iotdb.confignode.consensus.request.read.GetSchemaPartitionReq;
import org.apache.iotdb.confignode.consensus.request.read.GetStorageGroupReq;
import org.apache.iotdb.confignode.consensus.request.write.AdjustMaxRegionGroupCountReq;
import org.apache.iotdb.confignode.consensus.request.write.ApplyConfigNodeReq;
import org.apache.iotdb.confignode.consensus.request.write.CreateDataPartitionReq;
import org.apache.iotdb.confignode.consensus.request.write.CreateFunctionReq;
import org.apache.iotdb.confignode.consensus.request.write.CreateRegionsReq;
import org.apache.iotdb.confignode.consensus.request.write.CreateSchemaPartitionReq;
import org.apache.iotdb.confignode.consensus.request.write.DeleteProcedureReq;
import org.apache.iotdb.confignode.consensus.request.write.DeleteStorageGroupReq;
import org.apache.iotdb.confignode.consensus.request.write.DropFunctionReq;
import org.apache.iotdb.confignode.consensus.request.write.PreDeleteStorageGroupReq;
import org.apache.iotdb.confignode.consensus.request.write.RegisterDataNodeReq;
import org.apache.iotdb.confignode.consensus.request.write.RemoveConfigNodeReq;
import org.apache.iotdb.confignode.consensus.request.write.SetDataReplicationFactorReq;
import org.apache.iotdb.confignode.consensus.request.write.SetSchemaReplicationFactorReq;
import org.apache.iotdb.confignode.consensus.request.write.SetStorageGroupReq;
import org.apache.iotdb.confignode.consensus.request.write.SetTTLReq;
import org.apache.iotdb.confignode.consensus.request.write.SetTimePartitionIntervalReq;
import org.apache.iotdb.confignode.consensus.request.write.UpdateProcedureReq;
import org.apache.iotdb.confignode.consensus.response.SchemaNodeManagementResp;
import org.apache.iotdb.confignode.exception.physical.UnknownPhysicalPlanTypeException;
import org.apache.iotdb.confignode.persistence.AuthorInfo;
import org.apache.iotdb.confignode.persistence.ClusterSchemaInfo;
import org.apache.iotdb.confignode.persistence.NodeInfo;
import org.apache.iotdb.confignode.persistence.ProcedureInfo;
import org.apache.iotdb.confignode.persistence.UDFInfo;
import org.apache.iotdb.confignode.persistence.partition.PartitionInfo;
import org.apache.iotdb.consensus.common.DataSet;
import org.apache.iotdb.rpc.TSStatusCode;
import org.apache.thrift.TException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ConfigRequestExecutor {
    private static final Logger LOGGER = LoggerFactory.getLogger(ConfigRequestExecutor.class);
    private final NodeInfo nodeInfo;
    private final ClusterSchemaInfo clusterSchemaInfo;
    private final PartitionInfo partitionInfo;
    private final AuthorInfo authorInfo;
    private final ProcedureInfo procedureInfo;
    private final UDFInfo udfInfo;

    public ConfigRequestExecutor(NodeInfo nodeInfo, ClusterSchemaInfo clusterSchemaInfo, PartitionInfo partitionInfo, AuthorInfo authorInfo, ProcedureInfo procedureInfo, UDFInfo udfInfo) {
        this.nodeInfo = nodeInfo;
        this.clusterSchemaInfo = clusterSchemaInfo;
        this.partitionInfo = partitionInfo;
        this.authorInfo = authorInfo;
        this.procedureInfo = procedureInfo;
        this.udfInfo = udfInfo;
    }

    public DataSet executeQueryPlan(ConfigRequest req) throws UnknownPhysicalPlanTypeException, AuthException {
        switch (req.getType()) {
            case GetDataNodeInfo: {
                return this.nodeInfo.getDataNodeInfo((GetDataNodeInfoReq)req);
            }
            case CountStorageGroup: {
                return this.clusterSchemaInfo.countMatchedStorageGroups((CountStorageGroupReq)req);
            }
            case GetStorageGroup: {
                return this.clusterSchemaInfo.getMatchedStorageGroupSchemas((GetStorageGroupReq)req);
            }
            case GetDataPartition: 
            case GetOrCreateDataPartition: {
                return this.partitionInfo.getDataPartition((GetDataPartitionReq)req);
            }
            case GetSchemaPartition: 
            case GetOrCreateSchemaPartition: {
                return this.partitionInfo.getSchemaPartition((GetSchemaPartitionReq)req);
            }
            case ListUser: {
                return this.authorInfo.executeListUser();
            }
            case ListRole: {
                return this.authorInfo.executeListRole();
            }
            case ListUserPrivilege: {
                return this.authorInfo.executeListUserPrivileges((AuthorReq)req);
            }
            case ListRolePrivilege: {
                return this.authorInfo.executeListRolePrivileges((AuthorReq)req);
            }
            case ListUserRoles: {
                return this.authorInfo.executeListUserRoles((AuthorReq)req);
            }
            case ListRoleUsers: {
                return this.authorInfo.executeListRoleUsers((AuthorReq)req);
            }
            case GetNodePathsPartition: {
                return this.getSchemaNodeManagementPartition(req);
            }
            case GetRegionInfoList: {
                return this.partitionInfo.getRegionInfoList((GetRegionInfoListReq)req);
            }
        }
        throw new UnknownPhysicalPlanTypeException(req.getType());
    }

    public TSStatus executeNonQueryPlan(ConfigRequest req) throws UnknownPhysicalPlanTypeException, AuthException {
        switch (req.getType()) {
            case RegisterDataNode: {
                return this.nodeInfo.registerDataNode((RegisterDataNodeReq)req);
            }
            case SetStorageGroup: {
                TSStatus status = this.clusterSchemaInfo.setStorageGroup((SetStorageGroupReq)req);
                if (status.getCode() != TSStatusCode.SUCCESS_STATUS.getStatusCode()) {
                    return status;
                }
                return this.partitionInfo.setStorageGroup((SetStorageGroupReq)req);
            }
            case AdjustMaxRegionGroupCount: {
                return this.clusterSchemaInfo.adjustMaxRegionGroupCount((AdjustMaxRegionGroupCountReq)req);
            }
            case DeleteStorageGroup: {
                this.partitionInfo.deleteStorageGroup((DeleteStorageGroupReq)req);
                return this.clusterSchemaInfo.deleteStorageGroup((DeleteStorageGroupReq)req);
            }
            case PreDeleteStorageGroup: {
                return this.partitionInfo.preDeleteStorageGroup((PreDeleteStorageGroupReq)req);
            }
            case SetTTL: {
                return this.clusterSchemaInfo.setTTL((SetTTLReq)req);
            }
            case SetSchemaReplicationFactor: {
                return this.clusterSchemaInfo.setSchemaReplicationFactor((SetSchemaReplicationFactorReq)req);
            }
            case SetDataReplicationFactor: {
                return this.clusterSchemaInfo.setDataReplicationFactor((SetDataReplicationFactorReq)req);
            }
            case SetTimePartitionInterval: {
                return this.clusterSchemaInfo.setTimePartitionInterval((SetTimePartitionIntervalReq)req);
            }
            case CreateRegionGroups: {
                return this.partitionInfo.createRegionGroups((CreateRegionsReq)req);
            }
            case CreateSchemaPartition: {
                return this.partitionInfo.createSchemaPartition((CreateSchemaPartitionReq)req);
            }
            case CreateDataPartition: {
                return this.partitionInfo.createDataPartition((CreateDataPartitionReq)req);
            }
            case UpdateProcedure: {
                return this.procedureInfo.updateProcedure((UpdateProcedureReq)req);
            }
            case DeleteProcedure: {
                return this.procedureInfo.deleteProcedure((DeleteProcedureReq)req);
            }
            case CreateUser: 
            case CreateRole: 
            case DropUser: 
            case DropRole: 
            case GrantRole: 
            case GrantUser: 
            case GrantRoleToUser: 
            case RevokeUser: 
            case RevokeRole: 
            case RevokeRoleFromUser: 
            case UpdateUser: {
                return this.authorInfo.authorNonQuery((AuthorReq)req);
            }
            case ApplyConfigNode: {
                return this.nodeInfo.updateConfigNodeList((ApplyConfigNodeReq)req);
            }
            case RemoveConfigNode: {
                return this.nodeInfo.removeConfigNodeList((RemoveConfigNodeReq)req);
            }
            case CreateFunction: {
                return this.udfInfo.createFunction((CreateFunctionReq)req);
            }
            case DropFunction: {
                return this.udfInfo.dropFunction((DropFunctionReq)req);
            }
        }
        throw new UnknownPhysicalPlanTypeException(req.getType());
    }

    public boolean takeSnapshot(File snapshotDir) {
        File[] fileList;
        if (!snapshotDir.exists()) {
            LOGGER.warn("snapshot directory [{}] is not exist,start to create it.", (Object)snapshotDir.getAbsolutePath());
            if (!snapshotDir.mkdirs()) {
                LOGGER.error("snapshot directory [{}] can not be created.", (Object)snapshotDir.getAbsolutePath());
                return false;
            }
        }
        if ((fileList = snapshotDir.listFiles()) != null && fileList.length > 0) {
            LOGGER.error("snapshot directory [{}] is not empty.", (Object)snapshotDir.getAbsolutePath());
            return false;
        }
        AtomicBoolean result = new AtomicBoolean(true);
        this.getAllAttributes().parallelStream().forEach(x -> {
            boolean takeSnapshotResult = true;
            try {
                takeSnapshotResult = x.processTakeSnapshot(snapshotDir);
            }
            catch (IOException | TException e) {
                LOGGER.error(e.getMessage());
                takeSnapshotResult = false;
            }
            finally {
                if (!takeSnapshotResult) {
                    result.set(false);
                }
            }
        });
        return result.get();
    }

    public void loadSnapshot(File latestSnapshotRootDir) {
        if (!latestSnapshotRootDir.exists()) {
            LOGGER.error("snapshot directory [{}] is not exist, can not load snapshot with this directory.", (Object)latestSnapshotRootDir.getAbsolutePath());
            return;
        }
        this.getAllAttributes().parallelStream().forEach(x -> {
            try {
                x.processLoadSnapshot(latestSnapshotRootDir);
            }
            catch (IOException | TException e) {
                LOGGER.error(e.getMessage());
            }
        });
    }

    private DataSet getSchemaNodeManagementPartition(ConfigRequest req) {
        Set needMatchedNode;
        Set<String> alreadyMatchedNode;
        Object matchedChildInNextLevel;
        ArrayList<String> matchedStorageGroups = new ArrayList<String>();
        GetNodePathsPartitionReq getNodePathsPartitionReq = (GetNodePathsPartitionReq)req;
        PartialPath partialPath = getNodePathsPartitionReq.getPartialPath();
        int level = getNodePathsPartitionReq.getLevel();
        if (-1 == level) {
            matchedChildInNextLevel = this.clusterSchemaInfo.getChildNodePathInNextLevel(partialPath);
            alreadyMatchedNode = (Set<String>)matchedChildInNextLevel.left;
            needMatchedNode = (Set)matchedChildInNextLevel.right;
        } else {
            matchedChildInNextLevel = this.clusterSchemaInfo.getNodesListInGivenLevel(partialPath, level);
            alreadyMatchedNode = ((List)matchedChildInNextLevel.left).stream().map(PartialPath::getFullPath).collect(Collectors.toSet());
            needMatchedNode = (Set)matchedChildInNextLevel.right;
        }
        needMatchedNode.forEach(nodePath -> matchedStorageGroups.add(nodePath.getFullPath()));
        SchemaNodeManagementResp schemaNodeManagementResp = (SchemaNodeManagementResp)this.partitionInfo.getSchemaNodeManagementPartition(matchedStorageGroups);
        if (schemaNodeManagementResp.getStatus().getCode() == TSStatusCode.SUCCESS_STATUS.getStatusCode()) {
            schemaNodeManagementResp.setMatchedNode(alreadyMatchedNode);
        }
        return schemaNodeManagementResp;
    }

    private List<SnapshotProcessor> getAllAttributes() {
        ArrayList<SnapshotProcessor> allAttributes = new ArrayList<SnapshotProcessor>();
        allAttributes.add(this.clusterSchemaInfo);
        allAttributes.add(this.partitionInfo);
        allAttributes.add(this.nodeInfo);
        allAttributes.add(this.udfInfo);
        return allAttributes;
    }
}

