/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.confignode.manager.load.heartbeat;

import java.util.LinkedList;
import org.apache.iotdb.commons.cluster.NodeStatus;
import org.apache.iotdb.confignode.manager.load.heartbeat.HeartbeatPackage;
import org.apache.iotdb.confignode.manager.load.heartbeat.IHeartbeatStatistic;

public class ConfigNodeHeartbeatCache
implements IHeartbeatStatistic {
    private static final int maximumWindowSize = 100;
    private final LinkedList<HeartbeatPackage> slidingWindow = new LinkedList();
    private volatile NodeStatus status = NodeStatus.Running;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void cacheHeartBeat(HeartbeatPackage newHeartbeat) {
        LinkedList<HeartbeatPackage> linkedList = this.slidingWindow;
        synchronized (linkedList) {
            if (this.slidingWindow.size() == 0 || this.slidingWindow.getLast().getSendTimestamp() < newHeartbeat.getSendTimestamp()) {
                this.slidingWindow.add(newHeartbeat);
            }
            while (this.slidingWindow.size() > 100) {
                this.slidingWindow.removeFirst();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void updateLoadStatistic() {
        long lastSendTime = 0L;
        LinkedList<HeartbeatPackage> linkedList = this.slidingWindow;
        synchronized (linkedList) {
            if (this.slidingWindow.size() > 0) {
                lastSendTime = this.slidingWindow.getLast().getSendTimestamp();
            }
        }
        this.status = System.currentTimeMillis() - lastSendTime > 20000L ? NodeStatus.Unknown : NodeStatus.Running;
    }

    @Override
    public float getLoadScore() {
        switch (this.status) {
            case Running: {
                return 0.0f;
            }
        }
        return Float.MAX_VALUE;
    }

    @Override
    public NodeStatus getNodeStatus() {
        switch (this.status) {
            case Running: {
                return NodeStatus.Running;
            }
        }
        return NodeStatus.Unknown;
    }
}

