/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.confignode.manager.load.balancer;

import java.util.List;
import java.util.Map;
import org.apache.iotdb.common.rpc.thrift.TConsensusGroupId;
import org.apache.iotdb.common.rpc.thrift.TConsensusGroupType;
import org.apache.iotdb.common.rpc.thrift.TDataNodeInfo;
import org.apache.iotdb.common.rpc.thrift.TRegionReplicaSet;
import org.apache.iotdb.confignode.consensus.request.write.CreateRegionsReq;
import org.apache.iotdb.confignode.exception.NotEnoughDataNodeException;
import org.apache.iotdb.confignode.exception.StorageGroupNotExistsException;
import org.apache.iotdb.confignode.manager.ClusterSchemaManager;
import org.apache.iotdb.confignode.manager.IManager;
import org.apache.iotdb.confignode.manager.NodeManager;
import org.apache.iotdb.confignode.manager.PartitionManager;
import org.apache.iotdb.confignode.manager.load.balancer.region.CopySetRegionAllocator;
import org.apache.iotdb.confignode.manager.load.balancer.region.IRegionAllocator;
import org.apache.iotdb.confignode.rpc.thrift.TStorageGroupSchema;

public class RegionBalancer {
    private final IManager configManager;

    public RegionBalancer(IManager configManager) {
        this.configManager = configManager;
    }

    public CreateRegionsReq genRegionsAllocationPlan(Map<String, Integer> allotmentMap, TConsensusGroupType consensusGroupType) throws NotEnoughDataNodeException, StorageGroupNotExistsException {
        CreateRegionsReq createRegionGroupsReq = new CreateRegionsReq();
        IRegionAllocator regionAllocator = this.genRegionAllocator();
        List<TDataNodeInfo> onlineDataNodes = this.getNodeManager().getOnlineDataNodes(-1);
        List<TRegionReplicaSet> allocatedRegions = this.getPartitionManager().getAllReplicaSets();
        for (Map.Entry<String, Integer> entry : allotmentMap.entrySet()) {
            int replicationFactor;
            String storageGroup = entry.getKey();
            int allotment = entry.getValue();
            TStorageGroupSchema storageGroupSchema = this.getClusterSchemaManager().getStorageGroupSchemaByName(storageGroup);
            int n = replicationFactor = consensusGroupType == TConsensusGroupType.SchemaRegion ? storageGroupSchema.getSchemaReplicationFactor() : storageGroupSchema.getDataReplicationFactor();
            if (onlineDataNodes.size() < replicationFactor) {
                throw new NotEnoughDataNodeException();
            }
            for (int i = 0; i < allotment; ++i) {
                TRegionReplicaSet newRegion = regionAllocator.allocateRegion(onlineDataNodes, allocatedRegions, replicationFactor, new TConsensusGroupId(consensusGroupType, this.getPartitionManager().generateNextRegionGroupId()));
                createRegionGroupsReq.addRegionGroup(storageGroup, newRegion);
                allocatedRegions.add(newRegion);
            }
        }
        return createRegionGroupsReq;
    }

    private IRegionAllocator genRegionAllocator() {
        return new CopySetRegionAllocator();
    }

    private NodeManager getNodeManager() {
        return this.configManager.getNodeManager();
    }

    private ClusterSchemaManager getClusterSchemaManager() {
        return this.configManager.getClusterSchemaManager();
    }

    private PartitionManager getPartitionManager() {
        return this.configManager.getPartitionManager();
    }
}

