/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.confignode.consensus.response;

import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.iotdb.common.rpc.thrift.TConsensusGroupId;
import org.apache.iotdb.common.rpc.thrift.TRegionReplicaSet;
import org.apache.iotdb.common.rpc.thrift.TSStatus;
import org.apache.iotdb.commons.partition.SchemaPartitionTable;
import org.apache.iotdb.confignode.rpc.thrift.TSchemaPartitionResp;
import org.apache.iotdb.consensus.common.DataSet;
import org.apache.iotdb.rpc.TSStatusCode;

public class SchemaPartitionResp
implements DataSet {
    private TSStatus status;
    private final boolean allPartitionsExist;
    private final Map<String, SchemaPartitionTable> schemaPartition;

    public SchemaPartitionResp(TSStatus status, boolean allPartitionsExist, Map<String, SchemaPartitionTable> schemaPartition) {
        this.status = status;
        this.allPartitionsExist = allPartitionsExist;
        this.schemaPartition = schemaPartition;
    }

    public TSStatus getStatus() {
        return this.status;
    }

    public void setStatus(TSStatus status) {
        this.status = status;
    }

    public boolean isAllPartitionsExist() {
        return this.allPartitionsExist;
    }

    public TSchemaPartitionResp convertToRpcSchemaPartitionResp(Map<TConsensusGroupId, TRegionReplicaSet> replicaSetMap) {
        TSchemaPartitionResp resp = new TSchemaPartitionResp();
        resp.setStatus(this.status);
        if (this.status.getCode() == TSStatusCode.SUCCESS_STATUS.getStatusCode()) {
            ConcurrentHashMap schemaPartitionMap = new ConcurrentHashMap();
            this.schemaPartition.forEach((storageGroup, schemaPartitionTable) -> {
                ConcurrentHashMap seriesPartitionSlotMap = new ConcurrentHashMap();
                schemaPartitionTable.getSchemaPartitionMap().forEach((seriesPartitionSlot, consensusGroupId) -> {
                    TRegionReplicaSet cfr_ignored_0 = (TRegionReplicaSet)seriesPartitionSlotMap.put(seriesPartitionSlot, replicaSetMap.get(consensusGroupId));
                });
                schemaPartitionMap.put(storageGroup, seriesPartitionSlotMap);
            });
            resp.setSchemaRegionMap(schemaPartitionMap);
        }
        return resp;
    }
}

