/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.confignode.consensus.request.write;

import java.io.DataOutputStream;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.Objects;
import org.apache.iotdb.confignode.consensus.request.ConfigRequest;
import org.apache.iotdb.confignode.consensus.request.ConfigRequestType;
import org.apache.iotdb.confignode.procedure.Procedure;
import org.apache.iotdb.confignode.procedure.store.ProcedureFactory;

public class UpdateProcedureReq
extends ConfigRequest {
    private Procedure procedure;

    public Procedure getProcedure() {
        return this.procedure;
    }

    public void setProcedure(Procedure procedure) {
        this.procedure = procedure;
    }

    public UpdateProcedureReq() {
        super(ConfigRequestType.UpdateProcedure);
    }

    @Override
    protected void serializeImpl(DataOutputStream stream) throws IOException {
        stream.writeInt(ConfigRequestType.UpdateProcedure.ordinal());
        if (this.procedure != null) {
            this.procedure.serialize(stream);
        }
    }

    @Override
    protected void deserializeImpl(ByteBuffer buffer) throws IOException {
        Procedure procedure;
        this.procedure = procedure = ProcedureFactory.getInstance().create(buffer);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        UpdateProcedureReq that = (UpdateProcedureReq)o;
        return Objects.equals(this.procedure, that.procedure);
    }

    public int hashCode() {
        return Objects.hash(this.procedure);
    }
}

