/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.confignode.consensus.request.write;

import java.io.DataOutputStream;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.Objects;
import org.apache.iotdb.commons.utils.BasicStructureSerDeUtil;
import org.apache.iotdb.confignode.consensus.request.ConfigRequest;
import org.apache.iotdb.confignode.consensus.request.ConfigRequestType;

public class SetDataReplicationFactorReq
extends ConfigRequest {
    private String storageGroup;
    private int dataReplicationFactor;

    public SetDataReplicationFactorReq() {
        super(ConfigRequestType.SetDataReplicationFactor);
    }

    public SetDataReplicationFactorReq(String storageGroup, int dataReplicationFactor) {
        this();
        this.storageGroup = storageGroup;
        this.dataReplicationFactor = dataReplicationFactor;
    }

    public String getStorageGroup() {
        return this.storageGroup;
    }

    public int getDataReplicationFactor() {
        return this.dataReplicationFactor;
    }

    @Override
    protected void serializeImpl(DataOutputStream stream) throws IOException {
        stream.writeInt(this.getType().ordinal());
        BasicStructureSerDeUtil.write((String)this.storageGroup, (DataOutputStream)stream);
        stream.writeInt(this.dataReplicationFactor);
    }

    @Override
    protected void deserializeImpl(ByteBuffer buffer) throws IOException {
        this.storageGroup = BasicStructureSerDeUtil.readString((ByteBuffer)buffer);
        this.dataReplicationFactor = buffer.getInt();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        SetDataReplicationFactorReq that = (SetDataReplicationFactorReq)o;
        return this.dataReplicationFactor == that.dataReplicationFactor && this.storageGroup.equals(that.storageGroup);
    }

    public int hashCode() {
        return Objects.hash(this.storageGroup, this.dataReplicationFactor);
    }
}

