/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.confignode.consensus.request.write;

import java.io.DataOutputStream;
import java.io.IOException;
import java.nio.ByteBuffer;
import org.apache.iotdb.commons.utils.BasicStructureSerDeUtil;
import org.apache.iotdb.confignode.consensus.request.ConfigRequest;
import org.apache.iotdb.confignode.consensus.request.ConfigRequestType;

public class PreDeleteStorageGroupReq
extends ConfigRequest {
    private String storageGroup;
    private PreDeleteType preDeleteType;

    public PreDeleteStorageGroupReq() {
        super(ConfigRequestType.PreDeleteStorageGroup);
    }

    public PreDeleteStorageGroupReq(String storageGroup, PreDeleteType preDeleteType) {
        this();
        this.storageGroup = storageGroup;
        this.preDeleteType = preDeleteType;
    }

    public String getStorageGroup() {
        return this.storageGroup;
    }

    public void setStorageGroup(String storageGroup) {
        this.storageGroup = storageGroup;
    }

    public PreDeleteType getPreDeleteType() {
        return this.preDeleteType;
    }

    public void setPreDeleteType(PreDeleteType preDeleteType) {
        this.preDeleteType = preDeleteType;
    }

    @Override
    protected void serializeImpl(DataOutputStream stream) throws IOException {
        stream.writeInt(ConfigRequestType.PreDeleteStorageGroup.ordinal());
        BasicStructureSerDeUtil.write((String)this.storageGroup, (DataOutputStream)stream);
        stream.write(this.preDeleteType.getType());
    }

    @Override
    protected void deserializeImpl(ByteBuffer buffer) throws IOException {
        this.storageGroup = BasicStructureSerDeUtil.readString((ByteBuffer)buffer);
        this.preDeleteType = buffer.get() == 1 ? PreDeleteType.ROLLBACK : PreDeleteType.EXECUTE;
    }

    public static enum PreDeleteType {
        EXECUTE(0),
        ROLLBACK(1);

        private final byte type;

        private PreDeleteType(byte type) {
            this.type = type;
        }

        public byte getType() {
            return this.type;
        }
    }
}

