/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.confignode.consensus.request.read;

import java.io.DataOutputStream;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.apache.iotdb.common.rpc.thrift.TSeriesPartitionSlot;
import org.apache.iotdb.common.rpc.thrift.TTimePartitionSlot;
import org.apache.iotdb.commons.utils.BasicStructureSerDeUtil;
import org.apache.iotdb.commons.utils.ThriftCommonsSerDeUtils;
import org.apache.iotdb.confignode.consensus.request.ConfigRequest;
import org.apache.iotdb.confignode.consensus.request.ConfigRequestType;
import org.apache.iotdb.confignode.rpc.thrift.TDataPartitionReq;

public class GetDataPartitionReq
extends ConfigRequest {
    private Map<String, Map<TSeriesPartitionSlot, List<TTimePartitionSlot>>> partitionSlotsMap;

    public GetDataPartitionReq() {
        super(ConfigRequestType.GetDataPartition);
    }

    public GetDataPartitionReq(ConfigRequestType configRequestType) {
        super(configRequestType);
    }

    public Map<String, Map<TSeriesPartitionSlot, List<TTimePartitionSlot>>> getPartitionSlotsMap() {
        return this.partitionSlotsMap;
    }

    public void setPartitionSlotsMap(Map<String, Map<TSeriesPartitionSlot, List<TTimePartitionSlot>>> partitionSlotsMap) {
        this.partitionSlotsMap = partitionSlotsMap;
    }

    public void convertFromRpcTDataPartitionReq(TDataPartitionReq req) {
        this.partitionSlotsMap = new HashMap<String, Map<TSeriesPartitionSlot, List<TTimePartitionSlot>>>();
        req.getPartitionSlotsMap().forEach((storageGroup, tSeriesPartitionTimePartitionSlots) -> {
            this.partitionSlotsMap.putIfAbsent((String)storageGroup, new HashMap());
            tSeriesPartitionTimePartitionSlots.forEach((tSeriesPartitionSlot, tTimePartitionSlots) -> {
                this.partitionSlotsMap.get(storageGroup).putIfAbsent((TSeriesPartitionSlot)tSeriesPartitionSlot, new ArrayList());
                tTimePartitionSlots.forEach(tTimePartitionSlot -> this.partitionSlotsMap.get(storageGroup).get(tSeriesPartitionSlot).add((TTimePartitionSlot)tTimePartitionSlot));
            });
        });
    }

    @Override
    protected void serializeImpl(DataOutputStream stream) throws IOException {
        stream.writeInt(this.getType().ordinal());
        stream.writeInt(this.partitionSlotsMap.size());
        for (Map.Entry<String, Map<TSeriesPartitionSlot, List<TTimePartitionSlot>>> entry : this.partitionSlotsMap.entrySet()) {
            String storageGroup = entry.getKey();
            Map<TSeriesPartitionSlot, List<TTimePartitionSlot>> seriesPartitionTimePartitionSlots = entry.getValue();
            BasicStructureSerDeUtil.write((String)storageGroup, (DataOutputStream)stream);
            stream.writeInt(seriesPartitionTimePartitionSlots.size());
            for (Map.Entry<TSeriesPartitionSlot, List<TTimePartitionSlot>> e : seriesPartitionTimePartitionSlots.entrySet()) {
                TSeriesPartitionSlot seriesPartitionSlot = e.getKey();
                List<TTimePartitionSlot> timePartitionSlots = e.getValue();
                ThriftCommonsSerDeUtils.serializeTSeriesPartitionSlot((TSeriesPartitionSlot)seriesPartitionSlot, (DataOutputStream)stream);
                stream.writeInt(timePartitionSlots.size());
                timePartitionSlots.forEach(timePartitionSlot -> ThriftCommonsSerDeUtils.serializeTTimePartitionSlot((TTimePartitionSlot)timePartitionSlot, (DataOutputStream)stream));
            }
        }
    }

    @Override
    protected void deserializeImpl(ByteBuffer buffer) {
        this.partitionSlotsMap = new HashMap<String, Map<TSeriesPartitionSlot, List<TTimePartitionSlot>>>();
        int storageGroupNum = buffer.getInt();
        for (int i = 0; i < storageGroupNum; ++i) {
            String storageGroup = BasicStructureSerDeUtil.readString((ByteBuffer)buffer);
            this.partitionSlotsMap.put(storageGroup, new HashMap());
            int seriesPartitionSlotNum = buffer.getInt();
            for (int j = 0; j < seriesPartitionSlotNum; ++j) {
                TSeriesPartitionSlot seriesPartitionSlot = ThriftCommonsSerDeUtils.deserializeTSeriesPartitionSlot((ByteBuffer)buffer);
                this.partitionSlotsMap.get(storageGroup).put(seriesPartitionSlot, new ArrayList());
                int timePartitionSlotNum = buffer.getInt();
                for (int k = 0; k < timePartitionSlotNum; ++k) {
                    TTimePartitionSlot timePartitionSlot = ThriftCommonsSerDeUtils.deserializeTTimePartitionSlot((ByteBuffer)buffer);
                    this.partitionSlotsMap.get(storageGroup).get(seriesPartitionSlot).add(timePartitionSlot);
                }
            }
        }
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        GetDataPartitionReq that = (GetDataPartitionReq)o;
        return this.partitionSlotsMap.equals(that.partitionSlotsMap);
    }

    public int hashCode() {
        return Objects.hash(this.partitionSlotsMap);
    }
}

