/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.confignode.client.handlers;

import org.apache.iotdb.common.rpc.thrift.TDataNodeLocation;
import org.apache.iotdb.confignode.manager.load.heartbeat.DataNodeHeartbeatCache;
import org.apache.iotdb.confignode.manager.load.heartbeat.HeartbeatPackage;
import org.apache.iotdb.mpp.rpc.thrift.THeartbeatResp;
import org.apache.thrift.async.AsyncMethodCallback;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DataNodeHeartbeatHandler
implements AsyncMethodCallback<THeartbeatResp> {
    private static final Logger LOGGER = LoggerFactory.getLogger(DataNodeHeartbeatHandler.class);
    private final TDataNodeLocation dataNodeLocation;
    private final DataNodeHeartbeatCache dataNodeHeartbeatCache;

    public DataNodeHeartbeatHandler(TDataNodeLocation dataNodeLocation, DataNodeHeartbeatCache dataNodeHeartbeatCache) {
        this.dataNodeLocation = dataNodeLocation;
        this.dataNodeHeartbeatCache = dataNodeHeartbeatCache;
    }

    public void onComplete(THeartbeatResp tHeartbeatResp) {
        this.dataNodeHeartbeatCache.cacheHeartBeat(new HeartbeatPackage(tHeartbeatResp.getHeartbeatTimestamp(), System.currentTimeMillis()));
    }

    public void onError(Exception e) {
        LOGGER.warn("Heartbeat error on DataNode: {id={}, internalEndPoint={}}", new Object[]{this.dataNodeLocation.getDataNodeId(), this.dataNodeLocation.getInternalEndPoint(), e});
    }
}

