/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.confignode.client.handlers;

import org.apache.iotdb.common.rpc.thrift.TConfigNodeLocation;
import org.apache.iotdb.confignode.manager.load.heartbeat.ConfigNodeHeartbeatCache;
import org.apache.iotdb.confignode.manager.load.heartbeat.HeartbeatPackage;
import org.apache.thrift.async.AsyncMethodCallback;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ConfigNodeHeartbeatHandler
implements AsyncMethodCallback<Long> {
    private static final Logger LOGGER = LoggerFactory.getLogger(ConfigNodeHeartbeatHandler.class);
    private final TConfigNodeLocation configNodeLocation;
    private final ConfigNodeHeartbeatCache configNodeHeartbeatCache;

    public ConfigNodeHeartbeatHandler(TConfigNodeLocation configNodeLocation, ConfigNodeHeartbeatCache configNodeHeartbeatCache) {
        this.configNodeLocation = configNodeLocation;
        this.configNodeHeartbeatCache = configNodeHeartbeatCache;
    }

    public void onComplete(Long timestamp) {
        this.configNodeHeartbeatCache.cacheHeartBeat(new HeartbeatPackage(timestamp, System.currentTimeMillis()));
    }

    public void onError(Exception e) {
        LOGGER.warn("Heartbeat error on ConfigNode: {id={}, internalEndPoint={}}", new Object[]{this.configNodeLocation.getConfigNodeId(), this.configNodeLocation.getInternalEndPoint(), e});
    }
}

