/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.confignode.client;

import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Set;
import org.apache.iotdb.common.rpc.thrift.TConsensusGroupId;
import org.apache.iotdb.common.rpc.thrift.TDataNodeLocation;
import org.apache.iotdb.common.rpc.thrift.TEndPoint;
import org.apache.iotdb.common.rpc.thrift.TRegionReplicaSet;
import org.apache.iotdb.common.rpc.thrift.TSStatus;
import org.apache.iotdb.commons.client.IClientManager;
import org.apache.iotdb.commons.client.IClientPoolFactory;
import org.apache.iotdb.commons.client.sync.SyncDataNodeInternalServiceClient;
import org.apache.iotdb.confignode.client.ConfigNodeClientPoolFactory;
import org.apache.iotdb.mpp.rpc.thrift.TInvalidateCacheReq;
import org.apache.iotdb.mpp.rpc.thrift.TInvalidatePermissionCacheReq;
import org.apache.iotdb.rpc.TSStatusCode;
import org.apache.thrift.TException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SyncDataNodeClientPool {
    private static final Logger LOGGER = LoggerFactory.getLogger(SyncDataNodeClientPool.class);
    private final IClientManager<TEndPoint, SyncDataNodeInternalServiceClient> clientManager = new IClientManager.Factory().createClientManager((IClientPoolFactory)new ConfigNodeClientPoolFactory.SyncDataNodeInternalServiceClientPoolFactory());

    private SyncDataNodeClientPool() {
    }

    public TSStatus invalidatePartitionCache(TEndPoint endPoint, TInvalidateCacheReq invalidateCacheReq) {
        TSStatus status;
        try (SyncDataNodeInternalServiceClient client = (SyncDataNodeInternalServiceClient)this.clientManager.borrowClient((Object)endPoint);){
            status = client.invalidatePartitionCache(invalidateCacheReq);
            LOGGER.info("Invalid Schema Cache {} successfully", (Object)invalidateCacheReq);
        }
        catch (IOException e) {
            LOGGER.error("Can't connect to DataNode {}", (Object)endPoint, (Object)e);
            status = new TSStatus(TSStatusCode.TIME_OUT.getStatusCode());
        }
        catch (TException e) {
            LOGGER.error("Invalid Schema Cache on DataNode {} failed", (Object)endPoint, (Object)e);
            status = new TSStatus(TSStatusCode.EXECUTE_STATEMENT_ERROR.getStatusCode());
        }
        return status;
    }

    public TSStatus invalidateSchemaCache(TEndPoint endPoint, TInvalidateCacheReq invalidateCacheReq) {
        TSStatus status;
        try (SyncDataNodeInternalServiceClient client = (SyncDataNodeInternalServiceClient)this.clientManager.borrowClient((Object)endPoint);){
            status = client.invalidateSchemaCache(invalidateCacheReq);
        }
        catch (IOException e) {
            LOGGER.error("Can't connect to DataNode {}", (Object)endPoint, (Object)e);
            status = new TSStatus(TSStatusCode.TIME_OUT.getStatusCode());
        }
        catch (TException e) {
            LOGGER.error("Invalid Schema Cache on DataNode {} failed", (Object)endPoint, (Object)e);
            status = new TSStatus(TSStatusCode.EXECUTE_STATEMENT_ERROR.getStatusCode());
        }
        return status;
    }

    public void deleteRegions(Set<TRegionReplicaSet> deletedRegionSet) {
        HashMap<TDataNodeLocation, List> regionInfoMap = new HashMap<TDataNodeLocation, List>();
        deletedRegionSet.forEach(tRegionReplicaSet -> {
            for (TDataNodeLocation dataNodeLocation : tRegionReplicaSet.getDataNodeLocations()) {
                regionInfoMap.computeIfAbsent(dataNodeLocation, k -> new ArrayList()).add(tRegionReplicaSet.getRegionId());
            }
        });
        LOGGER.info("Current regionInfoMap {} ", regionInfoMap);
        regionInfoMap.forEach((dataNodeLocation, regionIds) -> this.deleteRegions(dataNodeLocation.getInternalEndPoint(), (List<TConsensusGroupId>)regionIds, deletedRegionSet));
    }

    private void deleteRegions(TEndPoint endPoint, List<TConsensusGroupId> regionIds, Set<TRegionReplicaSet> deletedRegionSet) {
        try (SyncDataNodeInternalServiceClient client = (SyncDataNodeInternalServiceClient)this.clientManager.borrowClient((Object)endPoint);){
            for (TConsensusGroupId regionId : regionIds) {
                LOGGER.debug("Delete region {} ", (Object)regionId);
                TSStatus status = client.deleteRegion(regionId);
                if (status.getCode() != TSStatusCode.SUCCESS_STATUS.getStatusCode()) continue;
                LOGGER.info("DELETE Region {} successfully", (Object)regionId);
                deletedRegionSet.removeIf(k -> k.getRegionId().equals(regionId));
            }
        }
        catch (IOException e) {
            LOGGER.error("Can't connect to DataNode {}", (Object)endPoint, (Object)e);
        }
        catch (TException e) {
            LOGGER.error("Delete Region on DataNode {} failed", (Object)endPoint, (Object)e);
        }
    }

    public TSStatus invalidatePermissionCache(TEndPoint endPoint, TInvalidatePermissionCacheReq invalidatePermissionCacheReq) {
        TSStatus status;
        try (SyncDataNodeInternalServiceClient client = (SyncDataNodeInternalServiceClient)this.clientManager.borrowClient((Object)endPoint);){
            status = client.invalidatePermissionCache(invalidatePermissionCacheReq);
        }
        catch (IOException e) {
            LOGGER.error("Can't connect to DataNode {}", (Object)endPoint, (Object)e);
            status = new TSStatus(TSStatusCode.TIME_OUT.getStatusCode());
        }
        catch (TException e) {
            LOGGER.error("Invalid Permission Cache on DataNode {} failed", (Object)endPoint, (Object)e);
            status = new TSStatus(TSStatusCode.EXECUTE_STATEMENT_ERROR.getStatusCode());
        }
        return status;
    }

    public static SyncDataNodeClientPool getInstance() {
        return ClientPoolHolder.INSTANCE;
    }

    private static class ClientPoolHolder {
        private static final SyncDataNodeClientPool INSTANCE = new SyncDataNodeClientPool();

        private ClientPoolHolder() {
        }
    }
}

