/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.confignode.client;

import java.util.Iterator;
import java.util.List;
import java.util.concurrent.TimeUnit;
import org.apache.iotdb.common.rpc.thrift.TConfigNodeLocation;
import org.apache.iotdb.common.rpc.thrift.TEndPoint;
import org.apache.iotdb.common.rpc.thrift.TSStatus;
import org.apache.iotdb.commons.client.IClientManager;
import org.apache.iotdb.commons.client.IClientPoolFactory;
import org.apache.iotdb.commons.client.sync.SyncConfigNodeIServiceClient;
import org.apache.iotdb.commons.utils.StatusUtils;
import org.apache.iotdb.confignode.rpc.thrift.TConfigNodeRegisterReq;
import org.apache.iotdb.confignode.rpc.thrift.TConfigNodeRegisterResp;
import org.apache.iotdb.db.client.DataNodeClientPoolFactory;
import org.apache.iotdb.rpc.TSStatusCode;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SyncConfigNodeClientPool {
    private static final Logger LOGGER = LoggerFactory.getLogger(SyncConfigNodeClientPool.class);
    private static final int retryNum = 6;
    private final IClientManager<TEndPoint, SyncConfigNodeIServiceClient> clientManager = new IClientManager.Factory().createClientManager((IClientPoolFactory)new DataNodeClientPoolFactory.SyncConfigNodeIServiceClientPoolFactory());
    private TEndPoint configNodeLeader = new TEndPoint();

    private SyncConfigNodeClientPool() {
    }

    private void updateConfigNodeLeader(TSStatus status) {
        this.configNodeLeader = status.isSetRedirectNode() ? status.getRedirectNode() : null;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public TConfigNodeRegisterResp registerConfigNode(TEndPoint endPoint, TConfigNodeRegisterReq req) {
        Exception lastException = null;
        int retry = 0;
        while (true) {
            if (retry >= 6) {
                LOGGER.error("Register ConfigNode failed", lastException);
                return new TConfigNodeRegisterResp().setStatus(new TSStatus(TSStatusCode.ALL_RETRY_FAILED.getStatusCode()).setMessage("All retry failed due to " + lastException.getMessage()));
            }
            try (SyncConfigNodeIServiceClient client = (SyncConfigNodeIServiceClient)this.clientManager.borrowClient((Object)endPoint);){
                TConfigNodeRegisterResp tConfigNodeRegisterResp = client.registerConfigNode(req);
                return tConfigNodeRegisterResp;
            }
            catch (Exception e) {
                lastException = e;
                LOGGER.warn("Register ConfigNode failed because {}, retrying {}...", (Object)e.getMessage(), (Object)retry);
                this.doRetryWait(retry);
                ++retry;
                continue;
            }
            break;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public TSStatus addConsensusGroup(TEndPoint endPoint, List<TConfigNodeLocation> configNodeLocation) {
        Throwable lastException = null;
        int retry = 0;
        while (true) {
            if (retry >= 6) {
                LOGGER.error("Add ConsensusGroup failed", lastException);
                return new TSStatus(TSStatusCode.ALL_RETRY_FAILED.getStatusCode()).setMessage("All retry failed due to " + lastException.getMessage());
            }
            try (SyncConfigNodeIServiceClient client = (SyncConfigNodeIServiceClient)this.clientManager.borrowClient((Object)endPoint);){
                TConfigNodeRegisterResp registerResp = new TConfigNodeRegisterResp();
                registerResp.setConfigNodeList(configNodeLocation);
                registerResp.setStatus(StatusUtils.OK);
                TSStatus tSStatus = client.addConsensusGroup(registerResp);
                return tSStatus;
            }
            catch (Throwable e) {
                lastException = e;
                LOGGER.warn("Add Consensus Group failed because {}, retrying {} ...", (Object)e.getMessage(), (Object)retry);
                this.doRetryWait(retry);
                ++retry;
                continue;
            }
            break;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public TSStatus removeConfigNode(List<TConfigNodeLocation> configNodeLocations, TConfigNodeLocation configNodeLocation) {
        Throwable lastException = null;
        Iterator<TConfigNodeLocation> iterator = configNodeLocations.iterator();
        block20: while (true) {
            if (!iterator.hasNext()) {
                LOGGER.error("Remove ConfigNode failed", lastException);
                return new TSStatus(TSStatusCode.ALL_RETRY_FAILED.getStatusCode()).setMessage("All retry failed due to " + lastException.getMessage());
            }
            TConfigNodeLocation nodeLocation = iterator.next();
            int retry = 0;
            while (true) {
                if (retry >= 6) continue block20;
                try (SyncConfigNodeIServiceClient client = (SyncConfigNodeIServiceClient)this.clientManager.borrowClient((Object)nodeLocation.getInternalEndPoint());){
                    TSStatus status = client.removeConfigNode(configNodeLocation);
                    while (status.getCode() == TSStatusCode.NEED_REDIRECTION.getStatusCode()) {
                        TimeUnit.MILLISECONDS.sleep(2000L);
                        this.updateConfigNodeLeader(status);
                        SyncConfigNodeIServiceClient clientLeader = (SyncConfigNodeIServiceClient)this.clientManager.borrowClient((Object)this.configNodeLeader);
                        Throwable throwable2 = null;
                        try {
                            status = clientLeader.removeConfigNode(configNodeLocation);
                        }
                        catch (Throwable throwable3) {
                            throwable2 = throwable3;
                            throw throwable3;
                        }
                        finally {
                            if (clientLeader == null) continue;
                            if (throwable2 != null) {
                                try {
                                    clientLeader.close();
                                }
                                catch (Throwable throwable4) {
                                    throwable2.addSuppressed(throwable4);
                                }
                                continue;
                            }
                            clientLeader.close();
                        }
                    }
                    TSStatus tSStatus = status;
                    return tSStatus;
                }
                catch (Throwable e) {
                    lastException = e;
                    LOGGER.warn("Remove ConfigNode failed because {}, retrying {} ...", (Object)e.getMessage(), (Object)retry);
                    this.doRetryWait(retry);
                    ++retry;
                    continue;
                }
                break;
            }
            break;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public TSStatus stopConfigNode(TConfigNodeLocation configNodeLocation) {
        Exception lastException = null;
        int retry = 0;
        while (true) {
            if (retry >= 6) {
                LOGGER.error("Stop ConfigNode failed", lastException);
                return new TSStatus(TSStatusCode.ALL_RETRY_FAILED.getStatusCode()).setMessage("All retry failed due to" + lastException.getMessage());
            }
            try (SyncConfigNodeIServiceClient client = (SyncConfigNodeIServiceClient)this.clientManager.borrowClient((Object)configNodeLocation.getInternalEndPoint());){
                TSStatus tSStatus = client.stopConfigNode(configNodeLocation);
                return tSStatus;
            }
            catch (Exception e) {
                lastException = e;
                LOGGER.warn("Stop ConfigNode failed because {}, retrying {}...", (Object)e.getMessage(), (Object)retry);
                this.doRetryWait(retry);
                ++retry;
                continue;
            }
            break;
        }
    }

    private void doRetryWait(int retryNum) {
        try {
            TimeUnit.MILLISECONDS.sleep(100L * (long)Math.pow(2.0, retryNum));
        }
        catch (InterruptedException e) {
            LOGGER.error("Retry wait failed.", (Throwable)e);
        }
    }

    public static SyncConfigNodeClientPool getInstance() {
        return SyncConfigNodeClientPoolHolder.INSTANCE;
    }

    private static class SyncConfigNodeClientPoolHolder {
        private static final SyncConfigNodeClientPool INSTANCE = new SyncConfigNodeClientPool();

        private SyncConfigNodeClientPoolHolder() {
        }
    }
}

