/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.consensus.ratis;

import java.io.IOException;
import java.util.concurrent.TimeUnit;
import org.apache.commons.pool2.PooledObject;
import org.apache.commons.pool2.impl.DefaultPooledObject;
import org.apache.iotdb.commons.client.BaseClientFactory;
import org.apache.iotdb.commons.client.ClientFactoryProperty;
import org.apache.iotdb.commons.client.ClientManager;
import org.apache.ratis.client.RaftClient;
import org.apache.ratis.client.RaftClientRpc;
import org.apache.ratis.conf.RaftProperties;
import org.apache.ratis.protocol.RaftGroup;
import org.apache.ratis.protocol.exceptions.RaftException;
import org.apache.ratis.retry.ExponentialBackoffRetry;
import org.apache.ratis.retry.RetryPolicy;
import org.apache.ratis.util.TimeDuration;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RatisClient {
    private final Logger logger = LoggerFactory.getLogger(RatisClient.class);
    private final RaftGroup serveGroup;
    private final RaftClient raftClient;
    private final ClientManager<RaftGroup, RatisClient> clientManager;

    public RatisClient(RaftGroup serveGroup, RaftClient client, ClientManager<RaftGroup, RatisClient> clientManager) {
        this.serveGroup = serveGroup;
        this.raftClient = client;
        this.clientManager = clientManager;
    }

    public RaftClient getRaftClient() {
        return this.raftClient;
    }

    public void close() {
        try {
            this.raftClient.close();
        }
        catch (IOException e) {
            this.logger.warn("cannot close raft client ", (Throwable)e);
        }
    }

    public void returnSelf() {
        if (this.clientManager != null) {
            this.clientManager.returnClient((Object)this.serveGroup, (Object)this);
        }
    }

    private static class RatisRetryPolicy
    implements RetryPolicy {
        private static final Logger logger = LoggerFactory.getLogger(RatisClient.class);
        private static final int maxAttempts = 10;
        RetryPolicy defaultPolicy = ExponentialBackoffRetry.newBuilder().setBaseSleepTime(TimeDuration.valueOf((long)100L, (TimeUnit)TimeUnit.MILLISECONDS)).setMaxSleepTime(TimeDuration.valueOf((long)10L, (TimeUnit)TimeUnit.SECONDS)).setMaxAttempts(10).build();

        public RetryPolicy.Action handleAttemptFailure(RetryPolicy.Event event) {
            if (event.getCause() != null && event.getCause() instanceof IOException && !(event.getCause() instanceof RaftException)) {
                logger.debug("raft client request failed and caught exception: ", event.getCause());
                return NO_RETRY_ACTION;
            }
            return this.defaultPolicy.handleAttemptFailure(event);
        }
    }

    public static class Factory
    extends BaseClientFactory<RaftGroup, RatisClient> {
        private final RaftProperties raftProperties;
        private final RaftClientRpc clientRpc;

        public Factory(ClientManager<RaftGroup, RatisClient> clientManager, ClientFactoryProperty clientPoolProperty, RaftProperties raftProperties, RaftClientRpc clientRpc) {
            super(clientManager, clientPoolProperty);
            this.raftProperties = raftProperties;
            this.clientRpc = clientRpc;
        }

        public void destroyObject(RaftGroup key, PooledObject<RatisClient> pooledObject) {
            ((RatisClient)pooledObject.getObject()).close();
        }

        public PooledObject<RatisClient> makeObject(RaftGroup group) throws Exception {
            return new DefaultPooledObject((Object)new RatisClient(group, RaftClient.newBuilder().setProperties(this.raftProperties).setRaftGroup(group).setRetryPolicy((RetryPolicy)new RatisRetryPolicy()).setClientRpc(this.clientRpc).build(), (ClientManager<RaftGroup, RatisClient>)this.clientManager));
        }

        public boolean validateObject(RaftGroup key, PooledObject<RatisClient> pooledObject) {
            return true;
        }
    }
}

