/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.consensus.config;

import org.apache.iotdb.common.rpc.thrift.TEndPoint;
import org.apache.iotdb.consensus.config.MultiLeaderConfig;
import org.apache.iotdb.consensus.config.RatisConfig;

public class ConsensusConfig {
    private final TEndPoint thisNode;
    private final String storageDir;
    private final RatisConfig ratisConfig;
    private final MultiLeaderConfig multiLeaderConfig;

    private ConsensusConfig(TEndPoint thisNode, String storageDir, RatisConfig ratisConfig, MultiLeaderConfig multiLeaderConfig) {
        this.thisNode = thisNode;
        this.storageDir = storageDir;
        this.ratisConfig = ratisConfig;
        this.multiLeaderConfig = multiLeaderConfig;
    }

    public TEndPoint getThisNode() {
        return this.thisNode;
    }

    public String getStorageDir() {
        return this.storageDir;
    }

    public RatisConfig getRatisConfig() {
        return this.ratisConfig;
    }

    public MultiLeaderConfig getMultiLeaderConfig() {
        return this.multiLeaderConfig;
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public static class Builder {
        private TEndPoint thisNode;
        private String storageDir;
        private RatisConfig ratisConfig;
        private MultiLeaderConfig multiLeaderConfig;

        public ConsensusConfig build() {
            return new ConsensusConfig(this.thisNode, this.storageDir, this.ratisConfig != null ? this.ratisConfig : RatisConfig.newBuilder().build(), this.multiLeaderConfig != null ? this.multiLeaderConfig : MultiLeaderConfig.newBuilder().build());
        }

        public Builder setThisNode(TEndPoint thisNode) {
            this.thisNode = thisNode;
            return this;
        }

        public Builder setStorageDir(String storageDir) {
            this.storageDir = storageDir;
            return this;
        }

        public Builder setRatisConfig(RatisConfig ratisConfig) {
            this.ratisConfig = ratisConfig;
            return this;
        }

        public Builder setMultiLeaderConfig(MultiLeaderConfig multiLeaderConfig) {
            this.multiLeaderConfig = multiLeaderConfig;
            return this;
        }
    }
}

