/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.consensus.common.request;

import java.nio.ByteBuffer;
import java.util.Objects;
import org.apache.iotdb.consensus.common.request.IConsensusRequest;

public class IndexedConsensusRequest
implements IConsensusRequest {
    private final long searchIndex;
    private final long safelyDeletedSearchIndex;
    private final IConsensusRequest request;

    public IndexedConsensusRequest(long searchIndex, long safelyDeletedSearchIndex, IConsensusRequest request) {
        this.searchIndex = searchIndex;
        this.safelyDeletedSearchIndex = safelyDeletedSearchIndex;
        this.request = request;
    }

    @Override
    public ByteBuffer serializeToByteBuffer() {
        return this.request.serializeToByteBuffer();
    }

    public IConsensusRequest getRequest() {
        return this.request;
    }

    public long getSearchIndex() {
        return this.searchIndex;
    }

    public long getSafelyDeletedSearchIndex() {
        return this.safelyDeletedSearchIndex;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        IndexedConsensusRequest that = (IndexedConsensusRequest)o;
        return this.searchIndex == that.searchIndex && this.safelyDeletedSearchIndex == that.safelyDeletedSearchIndex && Objects.equals(this.request, that.request);
    }

    public int hashCode() {
        return Objects.hash(this.searchIndex, this.safelyDeletedSearchIndex, this.request);
    }
}

