/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.metrics;

import java.util.ServiceLoader;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.iotdb.metrics.MetricManager;
import org.apache.iotdb.metrics.config.MetricConfig;
import org.apache.iotdb.metrics.config.MetricConfigDescriptor;
import org.apache.iotdb.metrics.config.ReloadLevel;
import org.apache.iotdb.metrics.impl.DoNothingMetricManager;
import org.apache.iotdb.metrics.reporter.CompositeReporter;
import org.apache.iotdb.metrics.reporter.Reporter;
import org.apache.iotdb.metrics.utils.PredefinedMetric;
import org.apache.iotdb.metrics.utils.ReporterType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class MetricService {
    private static final Logger logger = LoggerFactory.getLogger(MetricService.class);
    private final MetricConfig metricConfig = MetricConfigDescriptor.getInstance().getMetricConfig();
    protected MetricManager metricManager = new DoNothingMetricManager();
    protected CompositeReporter compositeReporter = new CompositeReporter();
    protected boolean isEnableMetric = this.metricConfig.getEnableMetric();
    private AtomicBoolean firstInit = new AtomicBoolean(true);

    public void startService() {
        this.loadManager();
        this.loadReporter();
        this.metricManager.init();
        if (!this.firstInit.getAndSet(false)) {
            this.startAllReporter();
        }
        logger.info("Start predefined metric:" + this.metricConfig.getPredefinedMetrics());
        for (PredefinedMetric predefinedMetric : this.metricConfig.getPredefinedMetrics()) {
            this.enablePredefinedMetric(predefinedMetric);
        }
        logger.info("Start metric at level: " + this.metricConfig.getMetricLevel().name());
    }

    public void stopService() {
        this.metricManager.stop();
        this.compositeReporter.stopAll();
        this.metricManager = new DoNothingMetricManager();
        this.compositeReporter = new CompositeReporter();
    }

    protected void loadManager() {
        logger.info("Load metricManager, type: {}", (Object)this.metricConfig.getMonitorType());
        ServiceLoader<MetricManager> metricManagers = ServiceLoader.load(MetricManager.class);
        int size = 0;
        for (MetricManager mf : metricManagers) {
            ++size;
            if (!mf.getClass().getName().toLowerCase().contains(this.metricConfig.getMonitorType().name().toLowerCase())) continue;
            this.metricManager = mf;
            break;
        }
        if (size == 0 || this.metricManager == null) {
            this.metricManager = new DoNothingMetricManager();
        } else if (size > 1) {
            logger.warn("detect more than one MetricManager, will use {}", (Object)this.metricManager.getClass().getName());
        }
    }

    protected void loadReporter() {
        logger.info("Load metric reporter, reporters: {}", this.metricConfig.getMetricReporterList());
        this.compositeReporter.clearReporter();
        ServiceLoader<Reporter> reporters = ServiceLoader.load(Reporter.class);
        for (Reporter reporter : reporters) {
            if (this.metricConfig.getMetricReporterList() == null || !this.metricConfig.getMetricReporterList().contains((Object)reporter.getReporterType()) || !reporter.getClass().getName().toLowerCase().contains(this.metricConfig.getMonitorType().name().toLowerCase())) continue;
            reporter.setMetricManager(this.metricManager);
            this.compositeReporter.addReporter(reporter);
        }
    }

    public void startAllReporter() {
        this.compositeReporter.startAll();
    }

    public void start(ReporterType reporter) {
        if (!this.isEnable()) {
            return;
        }
        this.compositeReporter.start(reporter);
    }

    public void stop(ReporterType reporter) {
        if (!this.isEnable()) {
            return;
        }
        this.compositeReporter.stop(reporter);
    }

    public abstract void enablePredefinedMetric(PredefinedMetric var1);

    protected abstract void reloadProperties(ReloadLevel var1);

    public MetricManager getMetricManager() {
        return this.metricManager;
    }

    public boolean isEnable() {
        return this.isEnableMetric;
    }
}

