/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.metrics.micrometer.reporter;

import io.micrometer.core.instrument.Clock;
import io.micrometer.core.instrument.MeterRegistry;
import io.micrometer.core.instrument.Metrics;
import io.micrometer.core.instrument.util.NamedThreadFactory;
import java.util.Set;
import java.util.concurrent.ThreadFactory;
import java.util.stream.Collectors;
import org.apache.iotdb.metrics.MetricManager;
import org.apache.iotdb.metrics.micrometer.reporter.IoTDBMeterRegistry;
import org.apache.iotdb.metrics.micrometer.reporter.IoTDBRegistryConfig;
import org.apache.iotdb.metrics.reporter.Reporter;
import org.apache.iotdb.metrics.utils.ReporterType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MicrometerIoTDBReporter
implements Reporter {
    private static final Logger LOGGER = LoggerFactory.getLogger(MicrometerIoTDBReporter.class);
    private MetricManager metricManager;

    public boolean start() {
        try {
            IoTDBMeterRegistry ioTDBMeterRegistry;
            Set meterRegistrySet = Metrics.globalRegistry.getRegistries().stream().filter(reporter -> reporter instanceof IoTDBMeterRegistry).collect(Collectors.toSet());
            if (meterRegistrySet.size() == 0) {
                ioTDBMeterRegistry = new IoTDBMeterRegistry(IoTDBRegistryConfig.DEFAULT, Clock.SYSTEM);
                Metrics.addRegistry((MeterRegistry)ioTDBMeterRegistry);
            } else {
                ioTDBMeterRegistry = (IoTDBMeterRegistry)((Object)meterRegistrySet.toArray()[0]);
            }
            ioTDBMeterRegistry.start((ThreadFactory)new NamedThreadFactory("iotdb-metrics-publisher"));
        }
        catch (Exception e) {
            LOGGER.error("Failed to start Micrometer IoTDBReporter, because {}", (Object)e.getMessage());
            return false;
        }
        return true;
    }

    public boolean stop() {
        try {
            Set meterRegistrySet = Metrics.globalRegistry.getRegistries().stream().filter(reporter -> reporter instanceof IoTDBMeterRegistry).collect(Collectors.toSet());
            for (MeterRegistry meterRegistry : meterRegistrySet) {
                if (meterRegistry.isClosed()) continue;
                meterRegistry.close();
                Metrics.removeRegistry((MeterRegistry)meterRegistry);
            }
        }
        catch (Exception e) {
            LOGGER.error("Failed to stop Micrometer IoTDBReporter, because {}", (Object)e.getMessage());
            return false;
        }
        return true;
    }

    public ReporterType getReporterType() {
        return ReporterType.IOTDB;
    }

    public void setMetricManager(MetricManager metricManager) {
        this.metricManager = metricManager;
    }
}

