/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.tsfile.read.reader.page;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.List;
import org.apache.iotdb.tsfile.encoding.decoder.Decoder;
import org.apache.iotdb.tsfile.file.header.PageHeader;
import org.apache.iotdb.tsfile.file.metadata.enums.TSDataType;
import org.apache.iotdb.tsfile.file.metadata.statistics.Statistics;
import org.apache.iotdb.tsfile.read.common.BatchData;
import org.apache.iotdb.tsfile.read.common.BatchDataFactory;
import org.apache.iotdb.tsfile.read.common.TimeRange;
import org.apache.iotdb.tsfile.read.common.block.TsBlock;
import org.apache.iotdb.tsfile.read.common.block.TsBlockBuilder;
import org.apache.iotdb.tsfile.read.filter.basic.Filter;
import org.apache.iotdb.tsfile.read.filter.operator.AndFilter;
import org.apache.iotdb.tsfile.read.reader.IAlignedPageReader;
import org.apache.iotdb.tsfile.read.reader.IPageReader;
import org.apache.iotdb.tsfile.read.reader.page.TimePageReader;
import org.apache.iotdb.tsfile.read.reader.page.ValuePageReader;
import org.apache.iotdb.tsfile.utils.TsPrimitiveType;

public class AlignedPageReader
implements IPageReader,
IAlignedPageReader {
    private final TimePageReader timePageReader;
    private final List<ValuePageReader> valuePageReaderList;
    private final int valueCount;
    private Filter filter;
    private boolean isModified;
    private TsBlockBuilder builder;

    public AlignedPageReader(PageHeader timePageHeader, ByteBuffer timePageData, Decoder timeDecoder, List<PageHeader> valuePageHeaderList, List<ByteBuffer> valuePageDataList, List<TSDataType> valueDataTypeList, List<Decoder> valueDecoderList, Filter filter) {
        this.timePageReader = new TimePageReader(timePageHeader, timePageData, timeDecoder);
        this.isModified = this.timePageReader.isModified();
        this.valuePageReaderList = new ArrayList<ValuePageReader>(valuePageHeaderList.size());
        for (int i = 0; i < valuePageHeaderList.size(); ++i) {
            if (valuePageHeaderList.get(i) != null) {
                ValuePageReader valuePageReader = new ValuePageReader(valuePageHeaderList.get(i), valuePageDataList.get(i), valueDataTypeList.get(i), valueDecoderList.get(i));
                this.valuePageReaderList.add(valuePageReader);
                this.isModified = this.isModified || valuePageReader.isModified();
                continue;
            }
            this.valuePageReaderList.add(null);
        }
        this.filter = filter;
        this.valueCount = this.valuePageReaderList.size();
    }

    @Override
    public BatchData getAllSatisfiedPageData(boolean ascending) throws IOException {
        BatchData pageData = BatchDataFactory.createBatchData(TSDataType.VECTOR, ascending, false);
        int timeIndex = -1;
        while (this.timePageReader.hasNextTime()) {
            long timestamp = this.timePageReader.nextTime();
            ++timeIndex;
            boolean isNull = true;
            Object notNullObject = null;
            TsPrimitiveType[] v = new TsPrimitiveType[this.valueCount];
            for (int i = 0; i < v.length; ++i) {
                ValuePageReader pageReader = this.valuePageReaderList.get(i);
                TsPrimitiveType tsPrimitiveType = v[i] = pageReader == null ? null : pageReader.nextValue(timestamp, timeIndex);
                if (v[i] == null) continue;
                isNull = false;
                notNullObject = v[i].getValue();
            }
            if (isNull || this.filter != null && !this.filter.satisfy(timestamp, notNullObject)) continue;
            pageData.putVector(timestamp, v);
        }
        return pageData.flip();
    }

    @Override
    public TsBlock getAllSatisfiedData() throws IOException {
        this.builder.reset();
        int timeIndex = -1;
        while (this.timePageReader.hasNextTime()) {
            int i;
            long timestamp = this.timePageReader.nextTime();
            ++timeIndex;
            boolean isNull = true;
            Object notNullObject = null;
            TsPrimitiveType[] v = new TsPrimitiveType[this.valueCount];
            for (i = 0; i < v.length; ++i) {
                ValuePageReader pageReader = this.valuePageReaderList.get(i);
                TsPrimitiveType tsPrimitiveType = v[i] = pageReader == null ? null : pageReader.nextValue(timestamp, timeIndex);
                if (v[i] == null) continue;
                isNull = false;
                notNullObject = v[i].getValue();
            }
            if (isNull || this.filter != null && !this.filter.satisfy(timestamp, notNullObject)) continue;
            this.builder.getTimeColumnBuilder().writeLong(timestamp);
            for (i = 0; i < v.length; ++i) {
                if (v[i] != null) {
                    this.builder.getColumnBuilder(i).writeTsPrimitiveType(v[i]);
                    continue;
                }
                this.builder.getColumnBuilder(i).appendNull();
            }
            this.builder.declarePosition();
        }
        return this.builder.build();
    }

    public void setDeleteIntervalList(List<List<TimeRange>> list) {
        for (int i = 0; i < this.valueCount; ++i) {
            if (this.valuePageReaderList.get(i) == null) continue;
            this.valuePageReaderList.get(i).setDeleteIntervalList(list.get(i));
        }
    }

    @Override
    public Statistics getStatistics() {
        return this.valuePageReaderList.size() == 1 && this.valuePageReaderList.get(0) != null ? this.valuePageReaderList.get(0).getStatistics() : this.timePageReader.getStatistics();
    }

    @Override
    public Statistics getStatistics(int index) {
        ValuePageReader valuePageReader = this.valuePageReaderList.get(index);
        return valuePageReader == null ? null : valuePageReader.getStatistics();
    }

    @Override
    public Statistics getTimeStatistics() {
        return this.timePageReader.getStatistics();
    }

    @Override
    public void setFilter(Filter filter) {
        this.filter = this.filter == null ? filter : new AndFilter(this.filter, filter);
    }

    @Override
    public boolean isModified() {
        return this.isModified;
    }

    @Override
    public void initTsBlockBuilder(List<TSDataType> dataTypes) {
        this.builder = new TsBlockBuilder(dataTypes);
    }
}

