/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.tsfile.read.common.block.column;

import java.io.DataOutputStream;
import java.io.IOException;
import java.nio.ByteBuffer;
import org.apache.iotdb.tsfile.file.metadata.enums.TSDataType;
import org.apache.iotdb.tsfile.read.common.block.column.Column;
import org.apache.iotdb.tsfile.read.common.block.column.ColumnBuilder;
import org.apache.iotdb.tsfile.read.common.block.column.ColumnEncoder;
import org.apache.iotdb.tsfile.read.common.block.column.DoubleColumnBuilder;
import org.apache.iotdb.tsfile.read.common.block.column.LongColumnBuilder;
import org.apache.iotdb.tsfile.read.common.block.column.TimeColumn;
import org.apache.iotdb.tsfile.read.common.block.column.TimeColumnBuilder;

public class Int64ArrayColumnEncoder
implements ColumnEncoder {
    @Override
    public TimeColumn readTimeColumn(ByteBuffer input, int positionCount) {
        return (TimeColumn)this.readColumnInternal(new TimeColumnBuilder(null, positionCount), input, positionCount);
    }

    @Override
    public Column readColumn(ByteBuffer input, TSDataType dataType, int positionCount) {
        if (TSDataType.INT64.equals((Object)dataType)) {
            return this.readColumnInternal(new LongColumnBuilder(null, positionCount), input, positionCount);
        }
        if (TSDataType.DOUBLE.equals((Object)dataType)) {
            return this.readColumnInternal(new DoubleColumnBuilder(null, positionCount), input, positionCount);
        }
        throw new IllegalArgumentException("Invalid data type: " + (Object)((Object)dataType));
    }

    private Column readColumnInternal(ColumnBuilder columnBuilder, ByteBuffer input, int positionCount) {
        boolean[] nullIndicators = ColumnEncoder.deserializeNullIndicators(input, positionCount);
        TSDataType dataType = columnBuilder.getDataType();
        if (TSDataType.INT64.equals((Object)dataType)) {
            for (int i = 0; i < positionCount; ++i) {
                if (nullIndicators == null || !nullIndicators[i]) {
                    columnBuilder.writeLong(input.getLong());
                    continue;
                }
                columnBuilder.appendNull();
            }
        } else if (TSDataType.DOUBLE.equals((Object)dataType)) {
            for (int i = 0; i < positionCount; ++i) {
                if (nullIndicators == null || !nullIndicators[i]) {
                    columnBuilder.writeDouble(Double.longBitsToDouble(input.getLong()));
                    continue;
                }
                columnBuilder.appendNull();
            }
        } else {
            throw new IllegalArgumentException("Invalid data type: " + (Object)((Object)dataType));
        }
        return columnBuilder.build();
    }

    @Override
    public void writeColumn(DataOutputStream output, Column column) throws IOException {
        ColumnEncoder.serializeNullIndicators(output, column);
        TSDataType dataType = column.getDataType();
        int positionCount = column.getPositionCount();
        if (TSDataType.INT64.equals((Object)dataType)) {
            for (int i = 0; i < positionCount; ++i) {
                if (column.isNull(i)) continue;
                output.writeLong(column.getLong(i));
            }
        } else if (TSDataType.DOUBLE.equals((Object)dataType)) {
            for (int i = 0; i < positionCount; ++i) {
                if (column.isNull(i)) continue;
                output.writeLong(Double.doubleToLongBits(column.getDouble(i)));
            }
        } else {
            throw new IllegalArgumentException("Invalid data type: " + (Object)((Object)dataType));
        }
    }
}

