/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.confignode.procedure.store;

import java.io.File;
import java.io.IOException;
import java.util.List;
import org.apache.iotdb.commons.conf.CommonDescriptor;
import org.apache.iotdb.confignode.consensus.request.write.DeleteProcedureReq;
import org.apache.iotdb.confignode.consensus.request.write.UpdateProcedureReq;
import org.apache.iotdb.confignode.manager.ConfigManager;
import org.apache.iotdb.confignode.manager.ConsensusManager;
import org.apache.iotdb.confignode.persistence.ProcedureInfo;
import org.apache.iotdb.confignode.procedure.Procedure;
import org.apache.iotdb.confignode.procedure.store.IProcedureStore;
import org.apache.iotdb.confignode.procedure.store.ProcedureFactory;
import org.apache.iotdb.confignode.procedure.store.ProcedureStore;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ConfigProcedureStore
implements IProcedureStore {
    private static final Logger LOG = LoggerFactory.getLogger(ProcedureStore.class);
    private volatile boolean isRunning = false;
    private final ProcedureInfo procedureInfo;
    private final String procedureWalDir = CommonDescriptor.getInstance().getConfig().getProcedureWalFolder();
    private final ConfigManager configManager;

    public ConfigProcedureStore(ConfigManager configManager, ProcedureInfo procedureInfo) {
        this.configManager = configManager;
        this.procedureInfo = procedureInfo;
        try {
            this.checkProcWalDir(this.procedureWalDir);
        }
        catch (IOException e) {
            LOG.error("ConfigProcedureStore start failed ", (Throwable)e);
        }
    }

    public ConsensusManager getConsensusManager() {
        return this.configManager.getConsensusManager();
    }

    @Override
    public boolean isRunning() {
        return this.isRunning;
    }

    @Override
    public void setRunning(boolean running) {
        this.isRunning = running;
    }

    @Override
    public void load(List<Procedure> procedureList) {
        this.procedureInfo.load(procedureList);
    }

    @Override
    public void update(Procedure procedure) {
        UpdateProcedureReq updateProcedureReq = new UpdateProcedureReq();
        ProcedureFactory.ProcedureType procedureType = ProcedureFactory.getProcedureType(procedure);
        if (procedureType != null) {
            updateProcedureReq.setProcedure(procedure);
        }
        this.getConsensusManager().write(updateProcedureReq);
    }

    @Override
    public void update(Procedure[] subprocs) {
        for (Procedure subproc : subprocs) {
            this.update(subproc);
        }
    }

    @Override
    public void delete(long procId) {
        DeleteProcedureReq deleteProcedureReq = new DeleteProcedureReq();
        deleteProcedureReq.setProcId(procId);
        this.getConsensusManager().write(deleteProcedureReq);
    }

    @Override
    public void delete(long[] childProcIds) {
        for (long childProcId : childProcIds) {
            this.delete(childProcId);
        }
    }

    @Override
    public void delete(long[] batchIds, int startIndex, int batchCount) {
        for (int i = startIndex; i < batchCount; ++i) {
            this.delete(batchIds[i]);
        }
    }

    @Override
    public void cleanup() {
    }

    @Override
    public void stop() {
        this.isRunning = false;
    }

    @Override
    public void start() {
        if (!this.isRunning) {
            this.isRunning = true;
        }
    }

    private void checkProcWalDir(String procedureWalDir) throws IOException {
        File dir = new File(procedureWalDir);
        if (!dir.exists()) {
            if (dir.mkdirs()) {
                LOG.info("Make procedure wal dir: {}", (Object)dir);
            } else {
                throw new IOException(String.format("Start ConfigNode failed, because couldn't make system dirs: %s.", dir.getAbsolutePath()));
            }
        }
    }
}

