/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.confignode.procedure.impl;

import java.io.DataOutputStream;
import java.io.IOException;
import java.nio.ByteBuffer;
import org.apache.iotdb.common.rpc.thrift.TConfigNodeLocation;
import org.apache.iotdb.commons.exception.runtime.ThriftSerDeException;
import org.apache.iotdb.commons.utils.ThriftConfigNodeSerDeUtils;
import org.apache.iotdb.confignode.procedure.StateMachineProcedure;
import org.apache.iotdb.confignode.procedure.env.ConfigNodeProcedureEnv;
import org.apache.iotdb.confignode.procedure.exception.ProcedureException;
import org.apache.iotdb.confignode.procedure.exception.ProcedureSuspendedException;
import org.apache.iotdb.confignode.procedure.exception.ProcedureYieldException;
import org.apache.iotdb.confignode.procedure.scheduler.SimpleProcedureScheduler;
import org.apache.iotdb.confignode.procedure.state.AddConfigNodeState;
import org.apache.iotdb.confignode.procedure.state.ProcedureLockState;
import org.apache.iotdb.confignode.procedure.store.ProcedureFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AddConfigNodeProcedure
extends StateMachineProcedure<ConfigNodeProcedureEnv, AddConfigNodeState> {
    private static final Logger LOG = LoggerFactory.getLogger(AddConfigNodeProcedure.class);
    private static final int retryThreshold = 5;
    private TConfigNodeLocation tConfigNodeLocation;

    public AddConfigNodeProcedure() {
    }

    public AddConfigNodeProcedure(TConfigNodeLocation tConfigNodeLocation) {
        this.tConfigNodeLocation = tConfigNodeLocation;
    }

    @Override
    protected StateMachineProcedure.Flow executeFromState(ConfigNodeProcedureEnv env, AddConfigNodeState state) throws ProcedureSuspendedException, ProcedureYieldException, InterruptedException {
        block9: {
            if (this.tConfigNodeLocation == null) {
                return StateMachineProcedure.Flow.NO_MORE_STATE;
            }
            try {
                switch (state) {
                    case ADD_CONFIG_NODE_PREPARE: {
                        this.setNextState(AddConfigNodeState.ADD_CONSENSUS_GROUP);
                        break;
                    }
                    case ADD_CONSENSUS_GROUP: {
                        env.addConsensusGroup(this.tConfigNodeLocation);
                        this.setNextState(AddConfigNodeState.ADD_PEER);
                        LOG.info("Add consensus group {}", (Object)this.tConfigNodeLocation);
                        break;
                    }
                    case ADD_PEER: {
                        env.addPeer(this.tConfigNodeLocation);
                        LOG.info("Add Peer of {}", (Object)this.tConfigNodeLocation);
                        return StateMachineProcedure.Flow.NO_MORE_STATE;
                    }
                }
            }
            catch (Exception e) {
                if (this.isRollbackSupported(state)) {
                    this.setFailure(new ProcedureException("Add Config Node failed " + (Object)((Object)state)));
                }
                LOG.error("Retriable error trying to add config node {}, state {}", new Object[]{this.tConfigNodeLocation, state, e});
                if (this.getCycles() <= 5) break block9;
                this.setFailure(new ProcedureException("State stuck at " + (Object)((Object)state)));
            }
        }
        return StateMachineProcedure.Flow.HAS_MORE_STATE;
    }

    @Override
    protected void rollbackState(ConfigNodeProcedureEnv env, AddConfigNodeState state) throws IOException, InterruptedException {
        switch (state) {
            case ADD_CONSENSUS_GROUP: 
            case ADD_PEER: {
                LOG.info("Rollback remove peer:{}", (Object)this.tConfigNodeLocation);
            }
        }
    }

    @Override
    protected boolean isRollbackSupported(AddConfigNodeState state) {
        switch (state) {
            case ADD_CONSENSUS_GROUP: 
            case ADD_PEER: {
                return true;
            }
        }
        return false;
    }

    @Override
    protected ProcedureLockState acquireLock(ConfigNodeProcedureEnv configNodeProcedureEnv) {
        if (configNodeProcedureEnv.getAddConfigNodeLock().tryLock()) {
            LOG.info("{} acquire lock.", (Object)this.getProcId());
            return ProcedureLockState.LOCK_ACQUIRED;
        }
        SimpleProcedureScheduler simpleProcedureScheduler = (SimpleProcedureScheduler)configNodeProcedureEnv.getScheduler();
        simpleProcedureScheduler.addWaiting(this);
        LOG.info("{} wait for lock.", (Object)this.getProcId());
        return ProcedureLockState.LOCK_EVENT_WAIT;
    }

    @Override
    protected void releaseLock(ConfigNodeProcedureEnv configNodeProcedureEnv) {
        LOG.info("{} release lock.", (Object)this.getProcId());
        configNodeProcedureEnv.getAddConfigNodeLock().unlock();
        SimpleProcedureScheduler simpleProcedureScheduler = (SimpleProcedureScheduler)configNodeProcedureEnv.getScheduler();
        simpleProcedureScheduler.releaseWaiting();
    }

    @Override
    protected boolean holdLock(ConfigNodeProcedureEnv configNodeProcedureEnv) {
        return configNodeProcedureEnv.getAddConfigNodeLock().isHeldByCurrentThread();
    }

    @Override
    protected AddConfigNodeState getState(int stateId) {
        return AddConfigNodeState.values()[stateId];
    }

    @Override
    protected int getStateId(AddConfigNodeState deleteStorageGroupState) {
        return deleteStorageGroupState.ordinal();
    }

    @Override
    protected AddConfigNodeState getInitialState() {
        return AddConfigNodeState.ADD_CONFIG_NODE_PREPARE;
    }

    @Override
    public void serialize(DataOutputStream stream) throws IOException {
        stream.writeInt(ProcedureFactory.ProcedureType.ADD_CONFIG_NODE_PROCEDURE.ordinal());
        super.serialize(stream);
        ThriftConfigNodeSerDeUtils.serializeTConfigNodeLocation((TConfigNodeLocation)this.tConfigNodeLocation, (DataOutputStream)stream);
    }

    @Override
    public void deserialize(ByteBuffer byteBuffer) {
        super.deserialize(byteBuffer);
        try {
            this.tConfigNodeLocation = ThriftConfigNodeSerDeUtils.deserializeTConfigNodeLocation((ByteBuffer)byteBuffer);
        }
        catch (ThriftSerDeException e) {
            LOG.error("Error in deserialize AddConfigNodeProcedure", (Throwable)e);
        }
    }

    public boolean equals(Object that) {
        if (that instanceof AddConfigNodeProcedure) {
            AddConfigNodeProcedure thatProc = (AddConfigNodeProcedure)that;
            return thatProc.getProcId() == this.getProcId() && thatProc.getState() == this.getState() && thatProc.tConfigNodeLocation.equals(this.tConfigNodeLocation);
        }
        return false;
    }
}

