/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.confignode.persistence;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.concurrent.ConcurrentNavigableMap;
import java.util.concurrent.ConcurrentSkipListMap;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.apache.iotdb.common.rpc.thrift.TConfigNodeLocation;
import org.apache.iotdb.common.rpc.thrift.TDataNodeInfo;
import org.apache.iotdb.common.rpc.thrift.TDataNodeLocation;
import org.apache.iotdb.common.rpc.thrift.TSStatus;
import org.apache.iotdb.commons.snapshot.SnapshotProcessor;
import org.apache.iotdb.commons.utils.NodeUrlUtils;
import org.apache.iotdb.confignode.conf.ConfigNodeDescriptor;
import org.apache.iotdb.confignode.consensus.request.read.GetDataNodeInfoReq;
import org.apache.iotdb.confignode.consensus.request.write.ApplyConfigNodeReq;
import org.apache.iotdb.confignode.consensus.request.write.RegisterDataNodeReq;
import org.apache.iotdb.confignode.consensus.request.write.RemoveConfigNodeReq;
import org.apache.iotdb.confignode.consensus.response.DataNodeInfosResp;
import org.apache.iotdb.db.service.metrics.MetricsService;
import org.apache.iotdb.db.service.metrics.enums.Metric;
import org.apache.iotdb.db.service.metrics.enums.Tag;
import org.apache.iotdb.metrics.config.MetricConfigDescriptor;
import org.apache.iotdb.metrics.utils.MetricLevel;
import org.apache.iotdb.rpc.TSStatusCode;
import org.apache.iotdb.tsfile.utils.ReadWriteIOUtils;
import org.apache.thrift.TException;
import org.apache.thrift.protocol.TBinaryProtocol;
import org.apache.thrift.protocol.TProtocol;
import org.apache.thrift.transport.TIOStreamTransport;
import org.apache.thrift.transport.TTransport;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NodeInfo
implements SnapshotProcessor {
    private static final Logger LOGGER = LoggerFactory.getLogger(NodeInfo.class);
    private static final File systemPropertiesFile = new File(ConfigNodeDescriptor.getInstance().getConf().getSystemDir() + File.separator + "confignode-system.properties");
    private static final int minimumDataNode = Math.max(ConfigNodeDescriptor.getInstance().getConf().getSchemaReplicationFactor(), ConfigNodeDescriptor.getInstance().getConf().getDataReplicationFactor());
    private final ReentrantReadWriteLock configNodeInfoReadWriteLock;
    private final Set<TConfigNodeLocation> onlineConfigNodes;
    private final ReentrantReadWriteLock dataNodeInfoReadWriteLock;
    private final AtomicInteger nextNodeId = new AtomicInteger(1);
    private final ConcurrentNavigableMap<Integer, TDataNodeInfo> onlineDataNodes = new ConcurrentSkipListMap<Integer, TDataNodeInfo>();
    private final Set<TDataNodeLocation> drainingDataNodes = new HashSet<TDataNodeLocation>();
    private final String snapshotFileName = "node_info.bin";

    public NodeInfo() {
        this.dataNodeInfoReadWriteLock = new ReentrantReadWriteLock();
        this.configNodeInfoReadWriteLock = new ReentrantReadWriteLock();
        this.onlineConfigNodes = new HashSet<TConfigNodeLocation>(ConfigNodeDescriptor.getInstance().getConf().getConfigNodeList());
    }

    public void addMetrics() {
        if (MetricConfigDescriptor.getInstance().getMetricConfig().getEnableMetric().booleanValue()) {
            MetricsService.getInstance().getMetricManager().getOrCreateAutoGauge(Metric.CONFIG_NODE.toString(), MetricLevel.CORE, this.onlineConfigNodes, o -> this.getOnlineDataNodeCount(), new String[]{Tag.NAME.toString(), "online"});
            MetricsService.getInstance().getMetricManager().getOrCreateAutoGauge(Metric.DATA_NODE.toString(), MetricLevel.CORE, this.onlineDataNodes, Map::size, new String[]{Tag.NAME.toString(), "online"});
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isOnlineDataNode(TDataNodeLocation info) {
        boolean result = false;
        this.dataNodeInfoReadWriteLock.readLock().lock();
        try {
            for (Map.Entry entry : this.onlineDataNodes.entrySet()) {
                info.setDataNodeId(((Integer)entry.getKey()).intValue());
                if (!((TDataNodeInfo)entry.getValue()).getLocation().equals(info)) continue;
                result = true;
                break;
            }
        }
        finally {
            this.dataNodeInfoReadWriteLock.readLock().unlock();
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public TSStatus registerDataNode(RegisterDataNodeReq registerDataNodeReq) {
        TSStatus result;
        TDataNodeInfo info = registerDataNodeReq.getInfo();
        this.dataNodeInfoReadWriteLock.writeLock().lock();
        try {
            this.onlineDataNodes.put(info.getLocation().getDataNodeId(), info);
            AtomicInteger atomicInteger = this.nextNodeId;
            synchronized (atomicInteger) {
                if (this.nextNodeId.get() < info.getLocation().getDataNodeId()) {
                    this.nextNodeId.set(info.getLocation().getDataNodeId());
                }
            }
            result = new TSStatus(TSStatusCode.SUCCESS_STATUS.getStatusCode());
            if (this.nextNodeId.get() < minimumDataNode) {
                result.setMessage(String.format("To enable IoTDB-Cluster's data service, please register %d more IoTDB-DataNode", minimumDataNode - this.nextNodeId.get()));
            } else if (this.nextNodeId.get() == minimumDataNode) {
                result.setMessage("IoTDB-Cluster could provide data service, now enjoy yourself!");
            }
        }
        finally {
            this.dataNodeInfoReadWriteLock.writeLock().unlock();
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DataNodeInfosResp getDataNodeInfo(GetDataNodeInfoReq getDataNodeInfoReq) {
        DataNodeInfosResp result = new DataNodeInfosResp();
        result.setStatus(new TSStatus(TSStatusCode.SUCCESS_STATUS.getStatusCode()));
        int dataNodeId = getDataNodeInfoReq.getDataNodeID();
        this.dataNodeInfoReadWriteLock.readLock().lock();
        try {
            if (dataNodeId == -1) {
                result.setDataNodeInfoMap(new HashMap<Integer, TDataNodeInfo>(this.onlineDataNodes));
            } else {
                result.setDataNodeInfoMap(Collections.singletonMap(dataNodeId, this.onlineDataNodes.get(dataNodeId)));
            }
        }
        finally {
            this.dataNodeInfoReadWriteLock.readLock().unlock();
        }
        return result;
    }

    public int getOnlineDataNodeCount() {
        int result;
        this.dataNodeInfoReadWriteLock.readLock().lock();
        try {
            result = this.onlineDataNodes.size();
        }
        finally {
            this.dataNodeInfoReadWriteLock.readLock().unlock();
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getTotalCpuCoreCount() {
        int result = 0;
        this.dataNodeInfoReadWriteLock.readLock().lock();
        try {
            for (TDataNodeInfo info : this.onlineDataNodes.values()) {
                result += info.getCpuCoreNum();
            }
        }
        finally {
            this.dataNodeInfoReadWriteLock.readLock().unlock();
        }
        return result;
    }

    public List<TDataNodeInfo> getOnlineDataNodes(int dataNodeId) {
        List result;
        this.dataNodeInfoReadWriteLock.readLock().lock();
        try {
            result = dataNodeId == -1 ? new ArrayList(this.onlineDataNodes.values()) : Collections.singletonList(this.onlineDataNodes.get(dataNodeId));
        }
        finally {
            this.dataNodeInfoReadWriteLock.readLock().unlock();
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public TSStatus updateConfigNodeList(ApplyConfigNodeReq applyConfigNodeReq) {
        TSStatus status = new TSStatus();
        this.configNodeInfoReadWriteLock.writeLock().lock();
        try {
            AtomicInteger atomicInteger = this.nextNodeId;
            synchronized (atomicInteger) {
                if (this.nextNodeId.get() < applyConfigNodeReq.getConfigNodeLocation().getConfigNodeId()) {
                    this.nextNodeId.set(applyConfigNodeReq.getConfigNodeLocation().getConfigNodeId());
                }
            }
            this.onlineConfigNodes.add(applyConfigNodeReq.getConfigNodeLocation());
            this.storeConfigNode();
            LOGGER.info("Successfully apply ConfigNode: {}. Current ConfigNodeGroup: {}", (Object)applyConfigNodeReq.getConfigNodeLocation(), this.onlineConfigNodes);
            status.setCode(TSStatusCode.SUCCESS_STATUS.getStatusCode());
        }
        catch (IOException e) {
            LOGGER.error("Update online ConfigNode failed.", (Throwable)e);
            status.setCode(TSStatusCode.APPLY_CONFIGNODE_FAILED.getStatusCode());
            status.setMessage("Apply new ConfigNode failed because current ConfigNode can't store ConfigNode information.");
        }
        finally {
            this.configNodeInfoReadWriteLock.writeLock().unlock();
        }
        return status;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public TSStatus removeConfigNodeList(RemoveConfigNodeReq removeConfigNodeReq) {
        TSStatus status = new TSStatus();
        this.configNodeInfoReadWriteLock.writeLock().lock();
        try {
            this.onlineConfigNodes.remove(removeConfigNodeReq.getConfigNodeLocation());
            this.storeConfigNode();
            LOGGER.info("Successfully remove ConfigNode: {}. Current ConfigNodeGroup: {}", (Object)removeConfigNodeReq.getConfigNodeLocation(), this.onlineConfigNodes);
            status.setCode(TSStatusCode.SUCCESS_STATUS.getStatusCode());
        }
        catch (IOException e) {
            LOGGER.error("Remove online ConfigNode failed.", (Throwable)e);
            status.setCode(TSStatusCode.REMOVE_CONFIGNODE_FAILED.getStatusCode());
            status.setMessage("Remove ConfigNode failed because current ConfigNode can't store ConfigNode information.");
        }
        finally {
            this.configNodeInfoReadWriteLock.writeLock().unlock();
        }
        return status;
    }

    private void storeConfigNode() throws IOException {
        Properties systemProperties = new Properties();
        try (FileInputStream inputStream = new FileInputStream(systemPropertiesFile);){
            systemProperties.load(inputStream);
        }
        systemProperties.setProperty("confignode_list", NodeUrlUtils.convertTConfigNodeUrls(new ArrayList<TConfigNodeLocation>(this.onlineConfigNodes)));
        var3_3 = null;
        try (FileOutputStream fileOutputStream = new FileOutputStream(systemPropertiesFile);){
            systemProperties.store(fileOutputStream, "");
        }
        catch (Throwable throwable) {
            var3_3 = throwable;
            throw throwable;
        }
    }

    public List<TConfigNodeLocation> getOnlineConfigNodes() {
        ArrayList<TConfigNodeLocation> result;
        this.configNodeInfoReadWriteLock.readLock().lock();
        try {
            result = new ArrayList<TConfigNodeLocation>(this.onlineConfigNodes);
        }
        finally {
            this.configNodeInfoReadWriteLock.readLock().unlock();
        }
        return result;
    }

    public int generateNextNodeId() {
        return this.nextNodeId.getAndIncrement();
    }

    /*
     * Exception decompiling
     */
    public boolean processTakeSnapshot(File snapshotDir) throws IOException, TException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 3 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private void serializeOnlineDataNode(OutputStream outputStream, TProtocol protocol) throws IOException, TException {
        ReadWriteIOUtils.write((int)this.onlineDataNodes.size(), (OutputStream)outputStream);
        for (Map.Entry entry : this.onlineDataNodes.entrySet()) {
            ReadWriteIOUtils.write((int)((Integer)entry.getKey()), (OutputStream)outputStream);
            ((TDataNodeInfo)entry.getValue()).write(protocol);
        }
    }

    private void serializeDrainingDataNodes(OutputStream outputStream, TProtocol protocol) throws IOException, TException {
        ReadWriteIOUtils.write((int)this.drainingDataNodes.size(), (OutputStream)outputStream);
        for (TDataNodeLocation tDataNodeLocation : this.drainingDataNodes) {
            tDataNodeLocation.write(protocol);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void processLoadSnapshot(File snapshotDir) throws IOException, TException {
        File snapshotFile = new File(snapshotDir, "node_info.bin");
        if (!snapshotFile.exists() || !snapshotFile.isFile()) {
            LOGGER.error("Failed to load snapshot,snapshot file [{}] is not exist.", (Object)snapshotFile.getAbsolutePath());
            return;
        }
        this.configNodeInfoReadWriteLock.writeLock().lock();
        this.dataNodeInfoReadWriteLock.writeLock().lock();
        try (FileInputStream fileInputStream = new FileInputStream(snapshotFile);
             TIOStreamTransport tioStreamTransport = new TIOStreamTransport((InputStream)fileInputStream);){
            TBinaryProtocol protocol = new TBinaryProtocol((TTransport)tioStreamTransport);
            this.clear();
            this.nextNodeId.set(ReadWriteIOUtils.readInt((InputStream)fileInputStream));
            this.deserializeOnlineDataNode(fileInputStream, (TProtocol)protocol);
            this.deserializeDrainingDataNodes(fileInputStream, (TProtocol)protocol);
        }
        finally {
            this.configNodeInfoReadWriteLock.writeLock().unlock();
            this.dataNodeInfoReadWriteLock.writeLock().unlock();
        }
    }

    private void deserializeOnlineDataNode(InputStream inputStream, TProtocol protocol) throws IOException, TException {
        for (int size = ReadWriteIOUtils.readInt((InputStream)inputStream); size > 0; --size) {
            int dataNodeId = ReadWriteIOUtils.readInt((InputStream)inputStream);
            TDataNodeInfo dataNodeInfo = new TDataNodeInfo();
            dataNodeInfo.read(protocol);
            this.onlineDataNodes.put(dataNodeId, dataNodeInfo);
        }
    }

    private void deserializeDrainingDataNodes(InputStream inputStream, TProtocol protocol) throws IOException, TException {
        for (int size = ReadWriteIOUtils.readInt((InputStream)inputStream); size > 0; --size) {
            TDataNodeLocation tDataNodeLocation = new TDataNodeLocation();
            tDataNodeLocation.read(protocol);
            this.drainingDataNodes.add(tDataNodeLocation);
        }
    }

    public void setDrainingDataNodes(Set<TDataNodeLocation> tDataNodeLocations) {
        this.drainingDataNodes.addAll(tDataNodeLocations);
    }

    public int getNextNodeId() {
        return this.nextNodeId.get();
    }

    public Set<TDataNodeLocation> getDrainingDataNodes() {
        return this.drainingDataNodes;
    }

    public void clear() {
        this.nextNodeId.set(0);
        this.onlineDataNodes.clear();
        this.drainingDataNodes.clear();
        this.onlineConfigNodes.clear();
    }
}

