/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.confignode.manager.load;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.Future;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import org.apache.iotdb.common.rpc.thrift.TConfigNodeLocation;
import org.apache.iotdb.common.rpc.thrift.TConsensusGroupId;
import org.apache.iotdb.common.rpc.thrift.TConsensusGroupType;
import org.apache.iotdb.common.rpc.thrift.TDataNodeInfo;
import org.apache.iotdb.common.rpc.thrift.TRegionReplicaSet;
import org.apache.iotdb.common.rpc.thrift.TSeriesPartitionSlot;
import org.apache.iotdb.common.rpc.thrift.TTimePartitionSlot;
import org.apache.iotdb.commons.concurrent.IoTDBThreadPoolFactory;
import org.apache.iotdb.commons.concurrent.threadpool.ScheduledExecutorUtil;
import org.apache.iotdb.commons.partition.DataPartitionTable;
import org.apache.iotdb.commons.partition.SchemaPartitionTable;
import org.apache.iotdb.confignode.client.AsyncConfigNodeClientPool;
import org.apache.iotdb.confignode.client.AsyncDataNodeClientPool;
import org.apache.iotdb.confignode.client.handlers.ConfigNodeHeartbeatHandler;
import org.apache.iotdb.confignode.client.handlers.DataNodeHeartbeatHandler;
import org.apache.iotdb.confignode.conf.ConfigNodeDescriptor;
import org.apache.iotdb.confignode.consensus.request.write.CreateRegionsReq;
import org.apache.iotdb.confignode.exception.NotEnoughDataNodeException;
import org.apache.iotdb.confignode.exception.StorageGroupNotExistsException;
import org.apache.iotdb.confignode.manager.ClusterSchemaManager;
import org.apache.iotdb.confignode.manager.ConsensusManager;
import org.apache.iotdb.confignode.manager.IManager;
import org.apache.iotdb.confignode.manager.NodeManager;
import org.apache.iotdb.confignode.manager.PartitionManager;
import org.apache.iotdb.confignode.manager.load.balancer.PartitionBalancer;
import org.apache.iotdb.confignode.manager.load.balancer.RegionBalancer;
import org.apache.iotdb.confignode.manager.load.balancer.RouteBalancer;
import org.apache.iotdb.confignode.manager.load.heartbeat.ConfigNodeHeartbeatCache;
import org.apache.iotdb.confignode.manager.load.heartbeat.DataNodeHeartbeatCache;
import org.apache.iotdb.confignode.manager.load.heartbeat.IHeartbeatStatistic;
import org.apache.iotdb.mpp.rpc.thrift.THeartbeatReq;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LoadManager {
    private static final Logger LOGGER = LoggerFactory.getLogger(LoadManager.class);
    private final IManager configManager;
    private final long heartbeatInterval = ConfigNodeDescriptor.getInstance().getConf().getHeartbeatInterval();
    private final Map<Integer, IHeartbeatStatistic> heartbeatCacheMap;
    private final RegionBalancer regionBalancer;
    private final PartitionBalancer partitionBalancer;
    private final RouteBalancer routeBalancer;
    private final ScheduledExecutorService heartBeatExecutor = IoTDBThreadPoolFactory.newSingleThreadScheduledExecutor((String)LoadManager.class.getSimpleName());
    private final Object heartbeatMonitor = new Object();
    private Future<?> currentHeartbeatFuture;
    private int balanceCount = 0;

    public LoadManager(IManager configManager) {
        this.configManager = configManager;
        this.heartbeatCacheMap = new ConcurrentHashMap<Integer, IHeartbeatStatistic>();
        this.regionBalancer = new RegionBalancer(configManager);
        this.partitionBalancer = new PartitionBalancer(configManager);
        this.routeBalancer = new RouteBalancer(configManager);
    }

    public void doRegionCreation(Map<String, Integer> allotmentMap, TConsensusGroupType consensusGroupType) throws NotEnoughDataNodeException, StorageGroupNotExistsException {
        CreateRegionsReq createRegionGroupsReq = this.regionBalancer.genRegionsAllocationPlan(allotmentMap, consensusGroupType);
        HashMap<String, Long> ttlMap = new HashMap<String, Long>();
        for (String storageGroup : createRegionGroupsReq.getRegionGroupMap().keySet()) {
            ttlMap.put(storageGroup, this.getClusterSchemaManager().getStorageGroupSchemaByName(storageGroup).getTTL());
        }
        AsyncDataNodeClientPool.getInstance().createRegions(createRegionGroupsReq, ttlMap);
        this.getConsensusManager().write(createRegionGroupsReq);
    }

    public Map<String, SchemaPartitionTable> allocateSchemaPartition(Map<String, List<TSeriesPartitionSlot>> unassignedSchemaPartitionSlotsMap) {
        return this.partitionBalancer.allocateSchemaPartition(unassignedSchemaPartitionSlotsMap);
    }

    public Map<String, DataPartitionTable> allocateDataPartition(Map<String, Map<TSeriesPartitionSlot, List<TTimePartitionSlot>>> unassignedDataPartitionSlotsMap) {
        return this.partitionBalancer.allocateDataPartition(unassignedDataPartitionSlotsMap);
    }

    public Map<TConsensusGroupId, TRegionReplicaSet> genRealTimeRoutingPolicy() {
        return this.routeBalancer.genRealTimeRoutingPolicy(this.getPartitionManager().getAllReplicaSets());
    }

    public Map<Integer, Float> getAllLoadScores() {
        ConcurrentHashMap<Integer, Float> result = new ConcurrentHashMap<Integer, Float>();
        this.heartbeatCacheMap.forEach((dataNodeId, heartbeatCache) -> result.put((Integer)dataNodeId, Float.valueOf(heartbeatCache.getLoadScore())));
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void start() {
        LOGGER.debug("Start Heartbeat Service of LoadManager");
        Object object = this.heartbeatMonitor;
        synchronized (object) {
            if (this.currentHeartbeatFuture == null) {
                this.currentHeartbeatFuture = ScheduledExecutorUtil.safelyScheduleWithFixedDelay((ScheduledExecutorService)this.heartBeatExecutor, this::heartbeatLoopBody, (long)0L, (long)this.heartbeatInterval, (TimeUnit)TimeUnit.MILLISECONDS);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stop() {
        LOGGER.debug("Stop Heartbeat Service of LoadManager");
        Object object = this.heartbeatMonitor;
        synchronized (object) {
            if (this.currentHeartbeatFuture != null) {
                this.currentHeartbeatFuture.cancel(false);
                this.currentHeartbeatFuture = null;
            }
        }
    }

    private void heartbeatLoopBody() {
        if (this.getConsensusManager().isLeader()) {
            this.pingOnlineDataNodes(this.getNodeManager().getOnlineDataNodes(-1));
            this.pingOnlineConfigNodes(this.getNodeManager().getOnlineConfigNodes());
            this.doLoadBalancing(this.balanceCount);
            ++this.balanceCount;
        }
    }

    private THeartbeatReq genHeartbeatReq() {
        return new THeartbeatReq(System.currentTimeMillis());
    }

    private void doLoadBalancing(int balanceCount) {
        if (balanceCount % 5 == 0) {
            this.updateNodeLoadStatistic();
        }
    }

    private void updateNodeLoadStatistic() {
        this.heartbeatCacheMap.values().forEach(IHeartbeatStatistic::updateLoadStatistic);
    }

    private void pingOnlineDataNodes(List<TDataNodeInfo> onlineDataNodes) {
        for (TDataNodeInfo dataNodeInfo : onlineDataNodes) {
            DataNodeHeartbeatHandler handler = new DataNodeHeartbeatHandler(dataNodeInfo.getLocation(), (DataNodeHeartbeatCache)this.heartbeatCacheMap.computeIfAbsent(dataNodeInfo.getLocation().getDataNodeId(), empty -> new DataNodeHeartbeatCache()));
            AsyncDataNodeClientPool.getInstance().getDataNodeHeartBeat(dataNodeInfo.getLocation().getInternalEndPoint(), this.genHeartbeatReq(), handler);
        }
    }

    private void pingOnlineConfigNodes(List<TConfigNodeLocation> onlineConfigNodes) {
        for (TConfigNodeLocation configNodeLocation : onlineConfigNodes) {
            ConfigNodeHeartbeatHandler handler = new ConfigNodeHeartbeatHandler(configNodeLocation, (ConfigNodeHeartbeatCache)this.heartbeatCacheMap.computeIfAbsent(configNodeLocation.getConfigNodeId(), empty -> new ConfigNodeHeartbeatCache()));
            AsyncConfigNodeClientPool.getInstance().getConfigNodeHeartBeat(configNodeLocation.getInternalEndPoint(), this.genHeartbeatReq().getHeartbeatTimestamp(), handler);
        }
    }

    public void removeNodeHeartbeatHandCache(Integer nodeId) {
        this.heartbeatCacheMap.remove(nodeId);
    }

    private ConsensusManager getConsensusManager() {
        return this.configManager.getConsensusManager();
    }

    private NodeManager getNodeManager() {
        return this.configManager.getNodeManager();
    }

    private ClusterSchemaManager getClusterSchemaManager() {
        return this.configManager.getClusterSchemaManager();
    }

    private PartitionManager getPartitionManager() {
        return this.configManager.getPartitionManager();
    }

    public Map<Integer, IHeartbeatStatistic> getHeartbeatCacheMap() {
        return this.heartbeatCacheMap;
    }
}

