/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.confignode.manager;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.CountDownLatch;
import org.apache.iotdb.common.rpc.thrift.TDataNodeInfo;
import org.apache.iotdb.common.rpc.thrift.TEndPoint;
import org.apache.iotdb.common.rpc.thrift.TSStatus;
import org.apache.iotdb.confignode.client.AsyncDataNodeClientPool;
import org.apache.iotdb.confignode.client.handlers.FunctionManagementHandler;
import org.apache.iotdb.confignode.consensus.request.write.CreateFunctionReq;
import org.apache.iotdb.confignode.consensus.request.write.DropFunctionReq;
import org.apache.iotdb.confignode.manager.ConfigManager;
import org.apache.iotdb.confignode.persistence.UDFInfo;
import org.apache.iotdb.mpp.rpc.thrift.TCreateFunctionRequest;
import org.apache.iotdb.mpp.rpc.thrift.TDropFunctionRequest;
import org.apache.iotdb.rpc.RpcUtils;
import org.apache.iotdb.rpc.TSStatusCode;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class UDFManager {
    private static final Logger LOGGER = LoggerFactory.getLogger(UDFManager.class);
    private final ConfigManager configManager;
    private final UDFInfo udfInfo;

    public UDFManager(ConfigManager configManager, UDFInfo udfInfo) {
        this.configManager = configManager;
        this.udfInfo = udfInfo;
    }

    public TSStatus createFunction(String functionName, String className, List<String> uris) {
        try {
            this.udfInfo.validateBeforeRegistration(functionName, className, uris);
            TSStatus configNodeStatus = this.configManager.getConsensusManager().write(new CreateFunctionReq(functionName, className, uris)).getStatus();
            if (configNodeStatus.getCode() != TSStatusCode.SUCCESS_STATUS.getStatusCode()) {
                return configNodeStatus;
            }
            return RpcUtils.squashResponseStatusList(this.createFunctionOnDataNodes(functionName, className, uris));
        }
        catch (Exception e) {
            String errorMessage = String.format("Failed to register UDF %s(class name: %s, uris: %s), because of exception: %s", functionName, className, uris, e);
            LOGGER.warn(errorMessage, (Throwable)e);
            return new TSStatus(TSStatusCode.EXECUTE_STATEMENT_ERROR.getStatusCode()).setMessage(errorMessage);
        }
    }

    private List<TSStatus> createFunctionOnDataNodes(String functionName, String className, List<String> uris) {
        List<TDataNodeInfo> onlineDataNodes = this.configManager.getNodeManager().getOnlineDataNodes(-1);
        List<TSStatus> dataNodeResponseStatus = Collections.synchronizedList(new ArrayList(onlineDataNodes.size()));
        CountDownLatch countDownLatch = new CountDownLatch(onlineDataNodes.size());
        TCreateFunctionRequest request = new TCreateFunctionRequest(functionName, className, uris);
        for (TDataNodeInfo dataNodeInfo : onlineDataNodes) {
            TEndPoint endPoint = dataNodeInfo.getLocation().getInternalEndPoint();
            AsyncDataNodeClientPool.getInstance().createFunction(endPoint, request, new FunctionManagementHandler(countDownLatch, dataNodeResponseStatus, endPoint.getIp(), endPoint.getPort()));
        }
        try {
            countDownLatch.await();
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            LOGGER.error("UDFManager was interrupted during creating functions on data nodes", (Throwable)e);
        }
        return dataNodeResponseStatus;
    }

    public TSStatus dropFunction(String functionName) {
        try {
            List<TSStatus> nodeResponseList = this.dropFunctionOnDataNodes(functionName);
            TSStatus configNodeStatus = this.configManager.getConsensusManager().write(new DropFunctionReq(functionName)).getStatus();
            nodeResponseList.add(configNodeStatus);
            return RpcUtils.squashResponseStatusList(nodeResponseList);
        }
        catch (Exception e) {
            String errorMessage = String.format("Failed to deregister UDF %s, because of exception: %s", functionName, e);
            LOGGER.warn(errorMessage, (Throwable)e);
            return new TSStatus(TSStatusCode.EXECUTE_STATEMENT_ERROR.getStatusCode()).setMessage(errorMessage);
        }
    }

    private List<TSStatus> dropFunctionOnDataNodes(String functionName) {
        List<TDataNodeInfo> onlineDataNodes = this.configManager.getNodeManager().getOnlineDataNodes(-1);
        List<TSStatus> dataNodeResponseStatus = Collections.synchronizedList(new ArrayList(onlineDataNodes.size()));
        CountDownLatch countDownLatch = new CountDownLatch(onlineDataNodes.size());
        TDropFunctionRequest request = new TDropFunctionRequest(functionName);
        for (TDataNodeInfo dataNodeInfo : onlineDataNodes) {
            TEndPoint endPoint = dataNodeInfo.getLocation().getInternalEndPoint();
            AsyncDataNodeClientPool.getInstance().dropFunction(endPoint, request, new FunctionManagementHandler(countDownLatch, dataNodeResponseStatus, endPoint.getIp(), endPoint.getPort()));
        }
        try {
            countDownLatch.await();
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            LOGGER.error("UDFManager was interrupted during dropping functions on data nodes", (Throwable)e);
        }
        return dataNodeResponseStatus;
    }
}

