/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.confignode.manager;

import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.TimeUnit;
import org.apache.iotdb.common.rpc.thrift.TSStatus;
import org.apache.iotdb.commons.utils.StatusUtils;
import org.apache.iotdb.confignode.conf.ConfigNodeConfig;
import org.apache.iotdb.confignode.conf.ConfigNodeDescriptor;
import org.apache.iotdb.confignode.manager.ConfigManager;
import org.apache.iotdb.confignode.manager.IManager;
import org.apache.iotdb.confignode.manager.PartitionManager;
import org.apache.iotdb.confignode.persistence.ProcedureInfo;
import org.apache.iotdb.confignode.procedure.Procedure;
import org.apache.iotdb.confignode.procedure.ProcedureExecutor;
import org.apache.iotdb.confignode.procedure.env.ConfigNodeProcedureEnv;
import org.apache.iotdb.confignode.procedure.impl.AddConfigNodeProcedure;
import org.apache.iotdb.confignode.procedure.impl.DeleteStorageGroupProcedure;
import org.apache.iotdb.confignode.procedure.scheduler.ProcedureScheduler;
import org.apache.iotdb.confignode.procedure.scheduler.SimpleProcedureScheduler;
import org.apache.iotdb.confignode.procedure.store.ConfigProcedureStore;
import org.apache.iotdb.confignode.procedure.store.IProcedureStore;
import org.apache.iotdb.confignode.procedure.store.ProcedureStore;
import org.apache.iotdb.confignode.rpc.thrift.TConfigNodeRegisterReq;
import org.apache.iotdb.confignode.rpc.thrift.TStorageGroupSchema;
import org.apache.iotdb.rpc.RpcUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ProcedureManager {
    private static final Logger LOGGER = LoggerFactory.getLogger(ProcedureManager.class);
    private static final ConfigNodeConfig CONFIG_NODE_CONFIG = ConfigNodeDescriptor.getInstance().getConf();
    private static final int procedureWaitTimeOut = 30;
    private static final int procedureWaitRetryTimeout = 250;
    private final ConfigManager configManager;
    private ProcedureExecutor<ConfigNodeProcedureEnv> executor;
    private ProcedureScheduler scheduler;
    private IProcedureStore store;
    private ConfigNodeProcedureEnv env;

    public ProcedureManager(ConfigManager configManager, ProcedureInfo procedureInfo) {
        this.configManager = configManager;
        this.scheduler = new SimpleProcedureScheduler();
        this.store = new ConfigProcedureStore(configManager, procedureInfo);
        this.env = new ConfigNodeProcedureEnv(configManager, this.scheduler);
        this.executor = new ProcedureExecutor<ConfigNodeProcedureEnv>(this.env, this.store, this.scheduler);
    }

    public void shiftExecutor(boolean running) {
        if (running) {
            if (!this.executor.isRunning()) {
                this.executor.init(CONFIG_NODE_CONFIG.getProcedureCoreWorkerThreadsSize());
                this.executor.startWorkers();
                this.executor.startCompletedCleaner(CONFIG_NODE_CONFIG.getProcedureCompletedCleanInterval(), CONFIG_NODE_CONFIG.getProcedureCompletedEvictTTL());
                this.store.start();
            }
        } else if (this.executor.isRunning()) {
            this.executor.stop();
            if (!this.executor.isRunning()) {
                this.executor.join();
                this.store.stop();
            }
        }
    }

    public TSStatus deleteStorageGroups(ArrayList<TStorageGroupSchema> deleteSgSchemaList) {
        ArrayList<Long> procIdList = new ArrayList<Long>();
        for (TStorageGroupSchema storageGroupSchema : deleteSgSchemaList) {
            DeleteStorageGroupProcedure deleteStorageGroupProcedure = new DeleteStorageGroupProcedure(storageGroupSchema);
            long procId = this.executor.submitProcedure(deleteStorageGroupProcedure);
            procIdList.add(procId);
        }
        ArrayList<TSStatus> procedureStatus = new ArrayList<TSStatus>();
        boolean isSucceed = ProcedureManager.getProcedureStatus(this.executor, procIdList, procedureStatus);
        PartitionManager partitionManager = this.getConfigManager().getPartitionManager();
        partitionManager.getRegionCleaner().submit(partitionManager::clearDeletedRegions);
        if (isSucceed) {
            return StatusUtils.OK;
        }
        return RpcUtils.getStatus(procedureStatus);
    }

    public void addConfigNode(TConfigNodeRegisterReq req) {
        AddConfigNodeProcedure addConfigNodeProcedure = new AddConfigNodeProcedure(req.getConfigNodeLocation());
        this.executor.submitProcedure(addConfigNodeProcedure);
    }

    private static boolean getProcedureStatus(ProcedureExecutor executor, List<Long> procIds, List<TSStatus> statusList) {
        boolean isSucceed = true;
        for (long procId : procIds) {
            long startTimeForProcId = System.currentTimeMillis();
            while (executor.isRunning() && !executor.isFinished(procId) && TimeUnit.MILLISECONDS.toSeconds(System.currentTimeMillis() - startTimeForProcId) < 30L) {
                ProcedureManager.sleepWithoutInterrupt(250L);
            }
            Procedure finishedProc = executor.getResultOrProcedure(procId);
            if (finishedProc.isSuccess()) {
                statusList.add(StatusUtils.OK);
                continue;
            }
            statusList.add(StatusUtils.EXECUTE_STATEMENT_ERROR.setMessage(finishedProc.getException().getMessage()));
            isSucceed = false;
        }
        return isSucceed;
    }

    public static void sleepWithoutInterrupt(long timeToSleep) {
        long currentTime = System.currentTimeMillis();
        long endTime = timeToSleep + currentTime;
        boolean interrupted = false;
        while (currentTime < endTime) {
            try {
                Thread.sleep(endTime - currentTime);
            }
            catch (InterruptedException e) {
                interrupted = true;
            }
            currentTime = System.currentTimeMillis();
        }
        if (interrupted) {
            Thread.currentThread().interrupt();
        }
    }

    public IManager getConfigManager() {
        return this.configManager;
    }

    public ProcedureExecutor<ConfigNodeProcedureEnv> getExecutor() {
        return this.executor;
    }

    public void setExecutor(ProcedureExecutor<ConfigNodeProcedureEnv> executor) {
        this.executor = executor;
    }

    public ProcedureScheduler getScheduler() {
        return this.scheduler;
    }

    public void setScheduler(ProcedureScheduler scheduler) {
        this.scheduler = scheduler;
    }

    public IProcedureStore getStore() {
        return this.store;
    }

    public void setStore(ProcedureStore store) {
        this.store = store;
    }

    public ConfigNodeProcedureEnv getEnv() {
        return this.env;
    }

    public void setEnv(ConfigNodeProcedureEnv env) {
        this.env = env;
    }
}

