/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.confignode.manager;

import java.util.List;
import org.apache.iotdb.common.rpc.thrift.TDataNodeInfo;
import org.apache.iotdb.common.rpc.thrift.TSStatus;
import org.apache.iotdb.confignode.client.SyncDataNodeClientPool;
import org.apache.iotdb.confignode.consensus.request.ConfigRequestType;
import org.apache.iotdb.confignode.consensus.request.auth.AuthorReq;
import org.apache.iotdb.confignode.consensus.response.PermissionInfoResp;
import org.apache.iotdb.confignode.manager.ConfigManager;
import org.apache.iotdb.confignode.manager.ConsensusManager;
import org.apache.iotdb.confignode.persistence.AuthorInfo;
import org.apache.iotdb.confignode.rpc.thrift.TPermissionInfoResp;
import org.apache.iotdb.mpp.rpc.thrift.TInvalidatePermissionCacheReq;
import org.apache.iotdb.rpc.RpcUtils;
import org.apache.iotdb.rpc.TSStatusCode;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PermissionManager {
    private static final Logger logger = LoggerFactory.getLogger(PermissionManager.class);
    private final ConfigManager configManager;
    private final AuthorInfo authorInfo;

    public PermissionManager(ConfigManager configManager, AuthorInfo authorInfo) {
        this.configManager = configManager;
        this.authorInfo = authorInfo;
    }

    public TSStatus operatePermission(AuthorReq authorReq) {
        TSStatus tsStatus;
        if (authorReq.getAuthorType() == ConfigRequestType.CreateUser || authorReq.getAuthorType() == ConfigRequestType.CreateRole) {
            tsStatus = this.getConsensusManager().write(authorReq).getStatus();
        } else {
            tsStatus = this.invalidateCache(authorReq.getUserName(), authorReq.getRoleName());
            if (tsStatus.getCode() == TSStatusCode.SUCCESS_STATUS.getStatusCode()) {
                tsStatus = this.getConsensusManager().write(authorReq).getStatus();
            }
        }
        return tsStatus;
    }

    public PermissionInfoResp queryPermission(AuthorReq authorReq) {
        return (PermissionInfoResp)this.getConsensusManager().read(authorReq).getDataset();
    }

    private ConsensusManager getConsensusManager() {
        return this.configManager.getConsensusManager();
    }

    public TPermissionInfoResp login(String username, String password) {
        return this.authorInfo.login(username, password);
    }

    public TPermissionInfoResp checkUserPrivileges(String username, List<String> paths, int permission) {
        return this.authorInfo.checkUserPrivileges(username, paths, permission);
    }

    public TSStatus invalidateCache(String username, String roleName) {
        List<TDataNodeInfo> allDataNodes = this.configManager.getNodeManager().getOnlineDataNodes(-1);
        TInvalidatePermissionCacheReq req = new TInvalidatePermissionCacheReq();
        req.setUsername(username);
        req.setRoleName(roleName);
        for (TDataNodeInfo dataNodeInfo : allDataNodes) {
            TSStatus status = SyncDataNodeClientPool.getInstance().invalidatePermissionCache(dataNodeInfo.getLocation().getInternalEndPoint(), req);
            if (status.getCode() == TSStatusCode.SUCCESS_STATUS.getStatusCode()) continue;
            return status;
        }
        return RpcUtils.getStatus((TSStatusCode)TSStatusCode.SUCCESS_STATUS);
    }
}

