/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.confignode.manager;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.TimeUnit;
import org.apache.iotdb.common.rpc.thrift.TConfigNodeLocation;
import org.apache.iotdb.common.rpc.thrift.TEndPoint;
import org.apache.iotdb.commons.consensus.ConsensusGroupId;
import org.apache.iotdb.commons.consensus.PartitionRegionId;
import org.apache.iotdb.confignode.conf.ConfigNodeConfig;
import org.apache.iotdb.confignode.conf.ConfigNodeDescriptor;
import org.apache.iotdb.confignode.consensus.request.ConfigRequest;
import org.apache.iotdb.confignode.consensus.request.write.ApplyConfigNodeReq;
import org.apache.iotdb.confignode.consensus.request.write.RemoveConfigNodeReq;
import org.apache.iotdb.confignode.consensus.statemachine.PartitionRegionStateMachine;
import org.apache.iotdb.confignode.manager.IManager;
import org.apache.iotdb.confignode.manager.NodeManager;
import org.apache.iotdb.consensus.ConsensusFactory;
import org.apache.iotdb.consensus.IConsensus;
import org.apache.iotdb.consensus.common.Peer;
import org.apache.iotdb.consensus.common.request.IConsensusRequest;
import org.apache.iotdb.consensus.common.response.ConsensusReadResponse;
import org.apache.iotdb.consensus.common.response.ConsensusWriteResponse;
import org.apache.iotdb.consensus.config.ConsensusConfig;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ConsensusManager {
    private static final Logger LOGGER = LoggerFactory.getLogger(ConsensusManager.class);
    private static final ConfigNodeConfig conf = ConfigNodeDescriptor.getInstance().getConf();
    private final IManager configManager;
    private ConsensusGroupId consensusGroupId;
    private IConsensus consensusImpl;

    public ConsensusManager(IManager configManager, PartitionRegionStateMachine stateMachine) throws IOException {
        this.configManager = configManager;
        this.setConsensusLayer(stateMachine);
    }

    public void close() throws IOException {
        this.consensusImpl.stop();
    }

    private void setConsensusLayer(PartitionRegionStateMachine stateMachine) throws IOException {
        this.consensusGroupId = new PartitionRegionId(conf.getPartitionRegionId());
        this.consensusImpl = (IConsensus)ConsensusFactory.getConsensusImpl((String)conf.getConfigNodeConsensusProtocolClass(), (ConsensusConfig)ConsensusConfig.newBuilder().setThisNode(new TEndPoint(conf.getRpcAddress(), conf.getConsensusPort())).setStorageDir(conf.getConsensusDir()).build(), gid -> stateMachine).orElseThrow(() -> new IllegalArgumentException(String.format("Construct consensusImpl failed, Please check your consensus className %s", conf.getConfigNodeConsensusProtocolClass())));
        this.consensusImpl.start();
        if (!conf.isNeedApply()) {
            this.addConsensusGroup(conf.getConfigNodeList());
        }
    }

    public void addConsensusGroup(List<TConfigNodeLocation> configNodeLocations) {
        if (configNodeLocations.size() == 0) {
            LOGGER.warn("configNodeLocations is null");
            return;
        }
        LOGGER.info("Set ConfigNode consensus group {}...", configNodeLocations);
        ArrayList<Peer> peerList = new ArrayList<Peer>();
        for (TConfigNodeLocation configNodeLocation : configNodeLocations) {
            peerList.add(new Peer(this.consensusGroupId, configNodeLocation.getConsensusEndPoint()));
        }
        this.consensusImpl.addConsensusGroup(this.consensusGroupId, peerList);
        conf.setConfigNodeList(configNodeLocations);
    }

    public boolean addConfigNodePeer(ApplyConfigNodeReq applyConfigNodeReq) {
        return this.consensusImpl.addPeer(this.consensusGroupId, new Peer(this.consensusGroupId, applyConfigNodeReq.getConfigNodeLocation().getConsensusEndPoint())).isSuccess();
    }

    public boolean removeConfigNodePeer(RemoveConfigNodeReq removeConfigNodeReq) {
        return this.consensusImpl.removePeer(this.consensusGroupId, new Peer(this.consensusGroupId, removeConfigNodeReq.getConfigNodeLocation().getConsensusEndPoint())).isSuccess();
    }

    public ConsensusWriteResponse write(ConfigRequest req) {
        return this.consensusImpl.write(this.consensusGroupId, (IConsensusRequest)req);
    }

    public ConsensusReadResponse read(ConfigRequest req) {
        return this.consensusImpl.read(this.consensusGroupId, (IConsensusRequest)req);
    }

    public boolean isLeader() {
        return this.consensusImpl.isLeader(this.consensusGroupId);
    }

    public TConfigNodeLocation getLeader() {
        for (int retry = 0; retry < 50; ++retry) {
            List<TConfigNodeLocation> onlineConfigNodes;
            TConfigNodeLocation leaderLocation;
            Peer leaderPeer = this.consensusImpl.getLeader(this.consensusGroupId);
            if (leaderPeer != null && (leaderLocation = (TConfigNodeLocation)(onlineConfigNodes = this.getNodeManager().getOnlineConfigNodes()).stream().filter(leader -> leader.getConsensusEndPoint().equals(leaderPeer.getEndpoint())).findFirst().orElse(null)) != null) {
                return leaderLocation;
            }
            try {
                TimeUnit.MILLISECONDS.sleep(100L);
                continue;
            }
            catch (InterruptedException e) {
                LOGGER.warn("ConsensusManager getLeader been interrupted, ", (Throwable)e);
            }
        }
        return null;
    }

    public ConsensusGroupId getConsensusGroupId() {
        return this.consensusGroupId;
    }

    public IConsensus getConsensusImpl() {
        return this.consensusImpl;
    }

    private NodeManager getNodeManager() {
        return this.configManager.getNodeManager();
    }

    public void singleCopyMayWaitUntilLeaderReady() {
        if (conf.getConfigNodeList().size() == 1) {
            long startTime = System.currentTimeMillis();
            long maxWaitTime = 60000L;
            try {
                while (!this.consensusImpl.isLeader(this.consensusGroupId)) {
                    TimeUnit.MILLISECONDS.sleep(100L);
                    long elapsed = System.currentTimeMillis() - startTime;
                    if (elapsed <= maxWaitTime) continue;
                    return;
                }
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
    }
}

