/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.confignode.consensus.response;

import java.util.Map;
import java.util.Vector;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.iotdb.common.rpc.thrift.TConsensusGroupId;
import org.apache.iotdb.common.rpc.thrift.TRegionReplicaSet;
import org.apache.iotdb.common.rpc.thrift.TSStatus;
import org.apache.iotdb.commons.partition.DataPartitionTable;
import org.apache.iotdb.confignode.rpc.thrift.TDataPartitionResp;
import org.apache.iotdb.consensus.common.DataSet;
import org.apache.iotdb.rpc.TSStatusCode;

public class DataPartitionResp
implements DataSet {
    private TSStatus status;
    private final boolean allPartitionsExist;
    private final Map<String, DataPartitionTable> dataPartition;

    public DataPartitionResp(TSStatus status, boolean allPartitionsExist, Map<String, DataPartitionTable> dataPartition) {
        this.status = status;
        this.allPartitionsExist = allPartitionsExist;
        this.dataPartition = dataPartition;
    }

    public TSStatus getStatus() {
        return this.status;
    }

    public void setStatus(TSStatus status) {
        this.status = status;
    }

    public boolean isAllPartitionsExist() {
        return this.allPartitionsExist;
    }

    public TDataPartitionResp convertToTDataPartitionResp(Map<TConsensusGroupId, TRegionReplicaSet> replicaSetMap) {
        TDataPartitionResp resp = new TDataPartitionResp();
        resp.setStatus(this.status);
        if (this.status.getCode() == TSStatusCode.SUCCESS_STATUS.getStatusCode()) {
            ConcurrentHashMap dataPartitionMap = new ConcurrentHashMap();
            this.dataPartition.forEach((storageGroup, dataPartitionTable) -> {
                ConcurrentHashMap seriesPartitionSlotMap = new ConcurrentHashMap();
                dataPartitionTable.getDataPartitionMap().forEach((seriesPartitionSlot, seriesPartitionTable) -> {
                    ConcurrentHashMap timePartitionSlotMap = new ConcurrentHashMap();
                    seriesPartitionTable.getSeriesPartitionMap().forEach((timePartitionSlot, consensusGroupIds) -> {
                        Vector regionReplicaSets = new Vector();
                        consensusGroupIds.forEach(consensusGroupId -> regionReplicaSets.add(replicaSetMap.get(consensusGroupId)));
                        timePartitionSlotMap.put(timePartitionSlot, regionReplicaSets);
                    });
                    seriesPartitionSlotMap.put(seriesPartitionSlot, timePartitionSlotMap);
                });
                dataPartitionMap.put(storageGroup, seriesPartitionSlotMap);
            });
            resp.setDataPartitionMap(dataPartitionMap);
        }
        return resp;
    }
}

