/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.confignode.consensus.request.write;

import java.io.DataOutputStream;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.Objects;
import org.apache.iotdb.commons.utils.BasicStructureSerDeUtil;
import org.apache.iotdb.confignode.consensus.request.ConfigRequest;
import org.apache.iotdb.confignode.consensus.request.ConfigRequestType;

public class SetTTLReq
extends ConfigRequest {
    private String storageGroup;
    private long TTL;

    public SetTTLReq() {
        super(ConfigRequestType.SetTTL);
    }

    public SetTTLReq(String storageGroup, long TTL) {
        this();
        this.storageGroup = storageGroup;
        this.TTL = TTL;
    }

    public String getStorageGroup() {
        return this.storageGroup;
    }

    public long getTTL() {
        return this.TTL;
    }

    @Override
    protected void serializeImpl(DataOutputStream stream) throws IOException {
        stream.writeInt(this.getType().ordinal());
        BasicStructureSerDeUtil.write((String)this.storageGroup, (DataOutputStream)stream);
        stream.writeLong(this.TTL);
    }

    @Override
    protected void deserializeImpl(ByteBuffer buffer) throws IOException {
        this.storageGroup = BasicStructureSerDeUtil.readString((ByteBuffer)buffer);
        this.TTL = buffer.getLong();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        SetTTLReq setTTLReq = (SetTTLReq)o;
        return this.TTL == setTTLReq.TTL && this.storageGroup.equals(setTTLReq.storageGroup);
    }

    public int hashCode() {
        return Objects.hash(this.storageGroup, this.TTL);
    }
}

