/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.confignode.consensus.request.write;

import java.io.DataOutputStream;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.apache.iotdb.common.rpc.thrift.TConsensusGroupId;
import org.apache.iotdb.commons.utils.BasicStructureSerDeUtil;
import org.apache.iotdb.commons.utils.ThriftCommonsSerDeUtils;
import org.apache.iotdb.confignode.consensus.request.ConfigRequest;
import org.apache.iotdb.confignode.consensus.request.ConfigRequestType;

public class DeleteRegionsReq
extends ConfigRequest {
    private final Map<String, List<TConsensusGroupId>> deleteRegionMap = new HashMap<String, List<TConsensusGroupId>>();

    public DeleteRegionsReq() {
        super(ConfigRequestType.DeleteRegions);
    }

    public void addDeleteRegion(String name, TConsensusGroupId consensusGroupId) {
        this.deleteRegionMap.computeIfAbsent(name, empty -> new ArrayList()).add(consensusGroupId);
    }

    public Map<String, List<TConsensusGroupId>> getDeleteRegionMap() {
        return this.deleteRegionMap;
    }

    @Override
    protected void serializeImpl(DataOutputStream stream) throws IOException {
        stream.writeInt(ConfigRequestType.DeleteRegions.ordinal());
        stream.writeInt(this.deleteRegionMap.size());
        for (Map.Entry<String, List<TConsensusGroupId>> consensusGroupIdsEntry : this.deleteRegionMap.entrySet()) {
            BasicStructureSerDeUtil.write((String)consensusGroupIdsEntry.getKey(), (DataOutputStream)stream);
            stream.writeInt(consensusGroupIdsEntry.getValue().size());
            for (TConsensusGroupId consensusGroupId : consensusGroupIdsEntry.getValue()) {
                ThriftCommonsSerDeUtils.serializeTConsensusGroupId((TConsensusGroupId)consensusGroupId, (DataOutputStream)stream);
            }
        }
    }

    @Override
    protected void deserializeImpl(ByteBuffer buffer) throws IOException {
        int length = buffer.getInt();
        for (int i = 0; i < length; ++i) {
            String name = BasicStructureSerDeUtil.readString((ByteBuffer)buffer);
            this.deleteRegionMap.put(name, new ArrayList());
            int regionNum = buffer.getInt();
            for (int j = 0; j < regionNum; ++j) {
                this.deleteRegionMap.get(name).add(ThriftCommonsSerDeUtils.deserializeTConsensusGroupId((ByteBuffer)buffer));
            }
        }
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        DeleteRegionsReq that = (DeleteRegionsReq)o;
        return this.deleteRegionMap.equals(that.deleteRegionMap);
    }

    public int hashCode() {
        return Objects.hash(this.deleteRegionMap);
    }
}

