/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.confignode.consensus.request.write;

import java.io.DataOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.List;
import org.apache.iotdb.confignode.consensus.request.ConfigRequest;
import org.apache.iotdb.confignode.consensus.request.ConfigRequestType;
import org.apache.iotdb.tsfile.utils.ReadWriteIOUtils;

public class CreateFunctionReq
extends ConfigRequest {
    private String functionName;
    private String className;
    private List<String> uris;

    public CreateFunctionReq() {
        super(ConfigRequestType.CreateFunction);
    }

    public CreateFunctionReq(String functionName, String className, List<String> uris) {
        super(ConfigRequestType.CreateFunction);
        this.functionName = functionName;
        this.className = className;
        this.uris = uris;
    }

    public String getFunctionName() {
        return this.functionName;
    }

    public String getClassName() {
        return this.className;
    }

    public List<String> getUris() {
        return this.uris;
    }

    @Override
    protected void serializeImpl(DataOutputStream stream) throws IOException {
        stream.writeInt(this.getType().ordinal());
        ReadWriteIOUtils.write((String)this.functionName, (OutputStream)stream);
        ReadWriteIOUtils.write((String)this.className, (OutputStream)stream);
        int size = this.uris.size();
        ReadWriteIOUtils.write((int)size, (OutputStream)stream);
        for (String uri : this.uris) {
            ReadWriteIOUtils.write((String)uri, (OutputStream)stream);
        }
    }

    @Override
    protected void deserializeImpl(ByteBuffer buffer) throws IOException {
        this.functionName = ReadWriteIOUtils.readString((ByteBuffer)buffer);
        this.className = ReadWriteIOUtils.readString((ByteBuffer)buffer);
        int size = ReadWriteIOUtils.readInt((ByteBuffer)buffer);
        this.uris = new ArrayList<String>(size);
        for (int i = 0; i < size; ++i) {
            this.uris.add(ReadWriteIOUtils.readString((ByteBuffer)buffer));
        }
    }
}

