/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.confignode.consensus.request.write;

import java.io.DataOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.apache.iotdb.confignode.consensus.request.ConfigRequest;
import org.apache.iotdb.confignode.consensus.request.ConfigRequestType;
import org.apache.iotdb.tsfile.utils.Pair;
import org.apache.iotdb.tsfile.utils.ReadWriteIOUtils;

public class AdjustMaxRegionGroupCountReq
extends ConfigRequest {
    public final Map<String, Pair<Integer, Integer>> maxRegionGroupCountMap = new HashMap<String, Pair<Integer, Integer>>();

    public AdjustMaxRegionGroupCountReq() {
        super(ConfigRequestType.AdjustMaxRegionGroupCount);
    }

    public void putEntry(String storageGroup, Pair<Integer, Integer> maxRegionGroupCount) {
        this.maxRegionGroupCountMap.put(storageGroup, maxRegionGroupCount);
    }

    public Map<String, Pair<Integer, Integer>> getMaxRegionGroupCountMap() {
        return this.maxRegionGroupCountMap;
    }

    @Override
    protected void serializeImpl(DataOutputStream stream) throws IOException {
        ReadWriteIOUtils.write((int)ConfigRequestType.AdjustMaxRegionGroupCount.ordinal(), (OutputStream)stream);
        ReadWriteIOUtils.write((int)this.maxRegionGroupCountMap.size(), (OutputStream)stream);
        for (Map.Entry<String, Pair<Integer, Integer>> maxRegionGroupCountEntry : this.maxRegionGroupCountMap.entrySet()) {
            ReadWriteIOUtils.write((String)maxRegionGroupCountEntry.getKey(), (OutputStream)stream);
            ReadWriteIOUtils.write((int)((Integer)maxRegionGroupCountEntry.getValue().getLeft()), (OutputStream)stream);
            ReadWriteIOUtils.write((int)((Integer)maxRegionGroupCountEntry.getValue().getRight()), (OutputStream)stream);
        }
    }

    @Override
    protected void deserializeImpl(ByteBuffer buffer) throws IOException {
        int storageGroupNum = buffer.getInt();
        for (int i = 0; i < storageGroupNum; ++i) {
            String storageGroup = ReadWriteIOUtils.readString((ByteBuffer)buffer);
            int maxSchemaRegionGroupCount = buffer.getInt();
            int maxDataRegionGroupCount = buffer.getInt();
            this.maxRegionGroupCountMap.put(storageGroup, (Pair<Integer, Integer>)new Pair((Object)maxSchemaRegionGroupCount, (Object)maxDataRegionGroupCount));
        }
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        AdjustMaxRegionGroupCountReq that = (AdjustMaxRegionGroupCountReq)o;
        return this.maxRegionGroupCountMap.equals(that.maxRegionGroupCountMap);
    }

    public int hashCode() {
        return Objects.hash(this.maxRegionGroupCountMap);
    }
}

