/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.confignode.consensus.request.read;

import java.io.DataOutputStream;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.Objects;
import org.apache.iotdb.confignode.consensus.request.ConfigRequest;
import org.apache.iotdb.confignode.consensus.request.ConfigRequestType;

public class GetDataNodeInfoReq
extends ConfigRequest {
    private int dataNodeID;

    public GetDataNodeInfoReq() {
        super(ConfigRequestType.GetDataNodeInfo);
    }

    public GetDataNodeInfoReq(int dataNodeID) {
        this();
        this.dataNodeID = dataNodeID;
    }

    public Integer getDataNodeID() {
        return this.dataNodeID;
    }

    @Override
    protected void serializeImpl(DataOutputStream stream) throws IOException {
        stream.writeInt(ConfigRequestType.GetDataNodeInfo.ordinal());
        stream.writeInt(this.dataNodeID);
    }

    @Override
    protected void deserializeImpl(ByteBuffer buffer) {
        this.dataNodeID = buffer.getInt();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        GetDataNodeInfoReq that = (GetDataNodeInfoReq)o;
        return this.dataNodeID == that.dataNodeID;
    }

    public int hashCode() {
        return Objects.hash(this.dataNodeID);
    }
}

