/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.confignode.consensus.request.auth;

import java.io.DataOutputStream;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.HashSet;
import java.util.Objects;
import java.util.Set;
import org.apache.iotdb.commons.auth.AuthException;
import org.apache.iotdb.commons.utils.BasicStructureSerDeUtil;
import org.apache.iotdb.confignode.consensus.request.ConfigRequest;
import org.apache.iotdb.confignode.consensus.request.ConfigRequestType;

public class AuthorReq
extends ConfigRequest {
    private ConfigRequestType authorType;
    private String roleName;
    private String password;
    private String newPassword;
    private Set<Integer> permissions;
    private String nodeName;
    private String userName;

    public AuthorReq(ConfigRequestType type) {
        super(type);
        this.authorType = type;
    }

    public AuthorReq(ConfigRequestType authorType, String userName, String roleName, String password, String newPassword, Set<Integer> permissions, String nodeName) throws AuthException {
        this(authorType);
        this.authorType = authorType;
        this.userName = userName;
        this.roleName = roleName;
        this.password = password;
        this.newPassword = newPassword;
        this.permissions = permissions;
        this.nodeName = nodeName;
    }

    public ConfigRequestType getAuthorType() {
        return this.authorType;
    }

    public void setAuthorType(ConfigRequestType authorType) {
        this.authorType = authorType;
    }

    public String getRoleName() {
        return this.roleName;
    }

    public void setRoleName(String roleName) {
        this.roleName = roleName;
    }

    public String getPassword() {
        return this.password;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    public String getNewPassword() {
        return this.newPassword;
    }

    public void setNewPassword(String newPassword) {
        this.newPassword = newPassword;
    }

    public Set<Integer> getPermissions() {
        return this.permissions;
    }

    public void setPermissions(Set<Integer> permissions) {
        this.permissions = permissions;
    }

    public String getNodeName() {
        return this.nodeName;
    }

    public void setNodeName(String nodeName) {
        this.nodeName = nodeName;
    }

    public String getUserName() {
        return this.userName;
    }

    public void setUserName(String userName) {
        this.userName = userName;
    }

    @Override
    protected void serializeImpl(DataOutputStream stream) throws IOException {
        BasicStructureSerDeUtil.write((int)this.getPlanTypeOrdinal(this.authorType), (DataOutputStream)stream);
        BasicStructureSerDeUtil.write((String)this.userName, (DataOutputStream)stream);
        BasicStructureSerDeUtil.write((String)this.roleName, (DataOutputStream)stream);
        BasicStructureSerDeUtil.write((String)this.password, (DataOutputStream)stream);
        BasicStructureSerDeUtil.write((String)this.newPassword, (DataOutputStream)stream);
        if (this.permissions == null) {
            stream.write(0);
        } else {
            stream.write(1);
            stream.writeInt(this.permissions.size());
            for (int permission : this.permissions) {
                stream.writeInt(permission);
            }
        }
        BasicStructureSerDeUtil.write((String)this.nodeName, (DataOutputStream)stream);
    }

    @Override
    protected void deserializeImpl(ByteBuffer buffer) {
        this.userName = BasicStructureSerDeUtil.readString((ByteBuffer)buffer);
        this.roleName = BasicStructureSerDeUtil.readString((ByteBuffer)buffer);
        this.password = BasicStructureSerDeUtil.readString((ByteBuffer)buffer);
        this.newPassword = BasicStructureSerDeUtil.readString((ByteBuffer)buffer);
        byte hasPermissions = buffer.get();
        if (hasPermissions == 0) {
            this.permissions = null;
        } else {
            int permissionsSize = buffer.getInt();
            this.permissions = new HashSet<Integer>();
            for (int i = 0; i < permissionsSize; ++i) {
                this.permissions.add(buffer.getInt());
            }
        }
        this.nodeName = BasicStructureSerDeUtil.readString((ByteBuffer)buffer);
    }

    private int getPlanTypeOrdinal(ConfigRequestType configRequestType) {
        int type;
        switch (configRequestType) {
            case CreateUser: {
                type = ConfigRequestType.CreateUser.ordinal();
                break;
            }
            case CreateRole: {
                type = ConfigRequestType.CreateRole.ordinal();
                break;
            }
            case DropUser: {
                type = ConfigRequestType.DropUser.ordinal();
                break;
            }
            case DropRole: {
                type = ConfigRequestType.DropRole.ordinal();
                break;
            }
            case GrantRole: {
                type = ConfigRequestType.GrantRole.ordinal();
                break;
            }
            case GrantUser: {
                type = ConfigRequestType.GrantUser.ordinal();
                break;
            }
            case GrantRoleToUser: {
                type = ConfigRequestType.GrantRoleToUser.ordinal();
                break;
            }
            case RevokeUser: {
                type = ConfigRequestType.RevokeUser.ordinal();
                break;
            }
            case RevokeRole: {
                type = ConfigRequestType.RevokeRole.ordinal();
                break;
            }
            case RevokeRoleFromUser: {
                type = ConfigRequestType.RevokeRoleFromUser.ordinal();
                break;
            }
            case UpdateUser: {
                type = ConfigRequestType.UpdateUser.ordinal();
                break;
            }
            case ListUser: {
                type = ConfigRequestType.ListUser.ordinal();
                break;
            }
            case ListRole: {
                type = ConfigRequestType.ListRole.ordinal();
                break;
            }
            case ListUserPrivilege: {
                type = ConfigRequestType.ListUserPrivilege.ordinal();
                break;
            }
            case ListRolePrivilege: {
                type = ConfigRequestType.ListRolePrivilege.ordinal();
                break;
            }
            case ListUserRoles: {
                type = ConfigRequestType.ListUserRoles.ordinal();
                break;
            }
            case ListRoleUsers: {
                type = ConfigRequestType.ListRoleUsers.ordinal();
                break;
            }
            default: {
                throw new IllegalArgumentException("Unknown operator: " + (Object)((Object)configRequestType));
            }
        }
        return type;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        AuthorReq that = (AuthorReq)o;
        return Objects.equals((Object)this.authorType, (Object)that.authorType) && Objects.equals(this.userName, that.userName) && Objects.equals(this.roleName, that.roleName) && Objects.equals(this.password, that.password) && Objects.equals(this.newPassword, that.newPassword) && Objects.equals(this.permissions, that.permissions) && Objects.equals(this.nodeName, that.nodeName);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.authorType, this.userName, this.roleName, this.password, this.newPassword, this.permissions, this.nodeName});
    }
}

