/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.confignode.conf;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.Collections;
import java.util.Objects;
import java.util.Properties;
import org.apache.iotdb.common.rpc.thrift.TConfigNodeLocation;
import org.apache.iotdb.common.rpc.thrift.TEndPoint;
import org.apache.iotdb.commons.conf.CommonDescriptor;
import org.apache.iotdb.commons.exception.BadNodeUrlException;
import org.apache.iotdb.commons.exception.ConfigurationException;
import org.apache.iotdb.commons.exception.StartupException;
import org.apache.iotdb.commons.utils.NodeUrlUtils;
import org.apache.iotdb.confignode.client.SyncConfigNodeClientPool;
import org.apache.iotdb.confignode.conf.ConfigNodeConfig;
import org.apache.iotdb.confignode.conf.ConfigNodeDescriptor;
import org.apache.iotdb.confignode.rpc.thrift.TConfigNodeRegisterReq;
import org.apache.iotdb.confignode.rpc.thrift.TConfigNodeRegisterResp;
import org.apache.iotdb.rpc.TSStatusCode;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ConfigNodeStartupCheck {
    private static final Logger LOGGER = LoggerFactory.getLogger(ConfigNodeStartupCheck.class);
    private static final ConfigNodeConfig conf = ConfigNodeDescriptor.getInstance().getConf();
    private final File systemPropertiesFile = new File(conf.getSystemDir() + File.separator + "confignode-system.properties");
    private final Properties systemProperties = new Properties();

    private ConfigNodeStartupCheck() {
    }

    public void startUpCheck() throws StartupException, IOException, ConfigurationException {
        this.checkGlobalConfig();
        if (this.isFirstStart()) {
            if (!this.isSeedConfigNode()) {
                this.registerConfigNode();
                conf.setNeedApply(true);
            }
            this.writeSystemProperties();
        } else {
            this.checkSystemProperties();
            this.loadConfigNodeList();
        }
    }

    private void checkGlobalConfig() throws ConfigurationException {
        if (conf.getConfigNodeConsensusProtocolClass().equals("org.apache.iotdb.consensus.standalone.StandAloneConsensus") && (!conf.getRpcAddress().equals(conf.getTargetConfigNode().getIp()) || conf.getRpcPort() != conf.getTargetConfigNode().getPort())) {
            throw new ConfigurationException("target_config_nodes", conf.getTargetConfigNode().getIp() + ":" + conf.getTargetConfigNode().getPort(), conf.getRpcAddress() + ":" + conf.getRpcPort());
        }
        if (conf.getDataRegionConsensusProtocolClass().equals("org.apache.iotdb.consensus.standalone.StandAloneConsensus") && conf.getDataReplicationFactor() != 1) {
            throw new ConfigurationException("data_replication_factor", String.valueOf(conf.getDataReplicationFactor()), String.valueOf(1));
        }
        if (conf.getSchemaRegionConsensusProtocolClass().equals("org.apache.iotdb.consensus.standalone.StandAloneConsensus") && conf.getSchemaReplicationFactor() != 1) {
            throw new ConfigurationException("schema_replication_factor", String.valueOf(conf.getSchemaReplicationFactor()), String.valueOf(1));
        }
        if (conf.getSchemaRegionConsensusProtocolClass().equals("org.apache.iotdb.consensus.multileader.MultiLeaderConsensus")) {
            throw new ConfigurationException("schema_region_consensus_protocol_class", String.valueOf(conf.getSchemaRegionConsensusProtocolClass()), String.format("%s or %s", "org.apache.iotdb.consensus.standalone.StandAloneConsensus", "org.apache.iotdb.consensus.ratis.RatisConsensus"));
        }
    }

    private boolean isFirstStart() throws IOException {
        boolean isFirstStart;
        File systemDir = new File(conf.getSystemDir());
        this.createDirIfEmpty(systemDir);
        File consensusDir = new File(conf.getConsensusDir());
        this.createDirIfEmpty(consensusDir);
        if (!this.systemPropertiesFile.exists()) {
            isFirstStart = true;
        } else {
            try (FileInputStream inputStream = new FileInputStream(this.systemPropertiesFile);){
                this.systemProperties.load(inputStream);
            }
            isFirstStart = false;
        }
        return isFirstStart;
    }

    private boolean isSeedConfigNode() {
        boolean result;
        boolean bl = result = conf.getRpcAddress().equals(conf.getTargetConfigNode().getIp()) && conf.getRpcPort() == conf.getTargetConfigNode().getPort();
        if (result) {
            conf.setConfigNodeList(Collections.singletonList(new TConfigNodeLocation(0, new TEndPoint(conf.getRpcAddress(), conf.getRpcPort()), new TEndPoint(conf.getRpcAddress(), conf.getConsensusPort()))));
        }
        return result;
    }

    private void registerConfigNode() throws StartupException {
        TConfigNodeRegisterResp resp;
        TConfigNodeRegisterReq req = new TConfigNodeRegisterReq(new TConfigNodeLocation(-1, new TEndPoint(conf.getRpcAddress(), conf.getRpcPort()), new TEndPoint(conf.getRpcAddress(), conf.getConsensusPort())), conf.getDataRegionConsensusProtocolClass(), conf.getSchemaRegionConsensusProtocolClass(), conf.getSeriesPartitionSlotNum(), conf.getSeriesPartitionExecutorClass(), CommonDescriptor.getInstance().getConfig().getDefaultTTL(), conf.getTimePartitionInterval(), conf.getSchemaReplicationFactor(), conf.getSchemaRegionPerDataNode(), conf.getDataReplicationFactor(), conf.getDataRegionPerProcessor());
        TEndPoint targetConfigNode = conf.getTargetConfigNode();
        while (true) {
            if ((resp = SyncConfigNodeClientPool.getInstance().registerConfigNode(targetConfigNode, req)).getStatus().getCode() == TSStatusCode.SUCCESS_STATUS.getStatusCode()) break;
            if (resp.getStatus().getCode() == TSStatusCode.NEED_REDIRECTION.getStatusCode()) {
                targetConfigNode = resp.getStatus().getRedirectNode();
                LOGGER.info("ConfigNode need redirect to  {}.", (Object)targetConfigNode);
            } else if (resp.getStatus().getCode() == TSStatusCode.ERROR_GLOBAL_CONFIG.getStatusCode()) {
                LOGGER.error("Configuration may not be consistent, {}", (Object)req);
                throw new StartupException("Configuration may not be consistent!");
            }
            try {
                Thread.sleep(1000L);
            }
            catch (InterruptedException e) {
                throw new StartupException("Register ConfigNode failed!");
            }
        }
        conf.setPartitionRegionId(resp.getPartitionRegionId().getId());
        conf.setConfigNodeList(resp.getConfigNodeList());
        LOGGER.info("ConfigNode registered successfully.");
    }

    private void writeSystemProperties() throws IOException, StartupException {
        if (!this.systemPropertiesFile.exists()) {
            if (this.systemPropertiesFile.createNewFile()) {
                LOGGER.info("System properties file {} for ConfigNode is created.", (Object)this.systemPropertiesFile.getAbsolutePath());
            } else {
                LOGGER.error("Can't create the system properties file {} for ConfigNode. IoTDB-ConfigNode is shutdown.", (Object)this.systemPropertiesFile.getAbsolutePath());
                throw new StartupException("Can't create system properties file");
            }
        }
        this.systemProperties.setProperty("rpc_address", String.valueOf(conf.getRpcAddress()));
        this.systemProperties.setProperty("rpc_port", String.valueOf(conf.getRpcPort()));
        this.systemProperties.setProperty("consensus_port", String.valueOf(conf.getConsensusPort()));
        this.systemProperties.setProperty("config_node_consensus_protocol_class", conf.getConfigNodeConsensusProtocolClass());
        this.systemProperties.setProperty("data_region_consensus_protocol_class", conf.getDataRegionConsensusProtocolClass());
        this.systemProperties.setProperty("schema_region_consensus_protocol_class", conf.getSchemaRegionConsensusProtocolClass());
        this.systemProperties.setProperty("series_partition_slot_num", String.valueOf(conf.getSeriesPartitionSlotNum()));
        this.systemProperties.setProperty("series_partition_executor_class", conf.getSeriesPartitionExecutorClass());
        this.systemProperties.setProperty("confignode_list", NodeUrlUtils.convertTConfigNodeUrls(conf.getConfigNodeList()));
        try (FileOutputStream fileOutputStream = new FileOutputStream(this.systemPropertiesFile);){
            this.systemProperties.store(fileOutputStream, "");
        }
        catch (IOException e) {
            if (!this.systemPropertiesFile.delete()) {
                LOGGER.error("Automatically deleting {} failed, please remove it manually.", (Object)this.systemPropertiesFile.getAbsolutePath());
            }
            LOGGER.error("Can't store system properties file {}.", (Object)this.systemPropertiesFile.getAbsolutePath());
            throw e;
        }
    }

    private void checkSystemProperties() throws ConfigurationException, IOException, StartupException {
        boolean needReWrite = false;
        String rpcAddress = this.systemProperties.getProperty("rpc_address", null);
        if (rpcAddress == null) {
            needReWrite = true;
        } else if (!rpcAddress.equals(conf.getRpcAddress())) {
            throw new ConfigurationException("rpc_address", conf.getRpcAddress(), rpcAddress);
        }
        if (this.systemProperties.getProperty("rpc_port", null) == null) {
            needReWrite = true;
        } else {
            int rpcPort = Integer.parseInt(this.systemProperties.getProperty("rpc_port"));
            if (rpcPort != conf.getRpcPort()) {
                throw new ConfigurationException("rpc_port", String.valueOf(conf.getRpcPort()), String.valueOf(rpcPort));
            }
        }
        if (this.systemProperties.getProperty("consensus_port", null) == null) {
            needReWrite = true;
        } else {
            int consensusPort = Integer.parseInt(this.systemProperties.getProperty("consensus_port"));
            if (consensusPort != conf.getConsensusPort()) {
                throw new ConfigurationException("consensus_port", String.valueOf(conf.getConsensusPort()), String.valueOf(consensusPort));
            }
        }
        String configNodeConsensusProtocolClass = this.systemProperties.getProperty("config_node_consensus_protocol_class", null);
        if (configNodeConsensusProtocolClass == null) {
            needReWrite = true;
        } else if (!configNodeConsensusProtocolClass.equals(conf.getConfigNodeConsensusProtocolClass())) {
            throw new ConfigurationException("config_node_consensus_protocol_class", conf.getConfigNodeConsensusProtocolClass(), configNodeConsensusProtocolClass);
        }
        String dataRegionConsensusProtocolClass = this.systemProperties.getProperty("data_region_consensus_protocol_class", null);
        if (dataRegionConsensusProtocolClass == null) {
            needReWrite = true;
        } else if (!dataRegionConsensusProtocolClass.equals(conf.getDataRegionConsensusProtocolClass())) {
            throw new ConfigurationException("data_region_consensus_protocol_class", conf.getDataRegionConsensusProtocolClass(), dataRegionConsensusProtocolClass);
        }
        String schemaRegionConsensusProtocolClass = this.systemProperties.getProperty("schema_region_consensus_protocol_class", null);
        if (schemaRegionConsensusProtocolClass == null) {
            needReWrite = true;
        } else if (!schemaRegionConsensusProtocolClass.equals(conf.getSchemaRegionConsensusProtocolClass())) {
            throw new ConfigurationException("schema_region_consensus_protocol_class", conf.getSchemaRegionConsensusProtocolClass(), schemaRegionConsensusProtocolClass);
        }
        if (this.systemProperties.getProperty("series_partition_slot_num", null) == null) {
            needReWrite = true;
        } else {
            int seriesPartitionSlotNum = Integer.parseInt(this.systemProperties.getProperty("series_partition_slot_num"));
            if (seriesPartitionSlotNum != conf.getSeriesPartitionSlotNum()) {
                throw new ConfigurationException("series_partition_slot_num", String.valueOf(conf.getSeriesPartitionSlotNum()), String.valueOf(seriesPartitionSlotNum));
            }
        }
        String seriesPartitionSlotExecutorClass = this.systemProperties.getProperty("series_partition_executor_class", null);
        if (seriesPartitionSlotExecutorClass == null) {
            needReWrite = true;
        } else if (!Objects.equals(seriesPartitionSlotExecutorClass, conf.getSeriesPartitionExecutorClass())) {
            throw new ConfigurationException("series_partition_executor_class", conf.getSeriesPartitionExecutorClass(), seriesPartitionSlotExecutorClass);
        }
        if (needReWrite) {
            this.writeSystemProperties();
        }
    }

    private void loadConfigNodeList() throws StartupException {
        String addresses = this.systemProperties.getProperty("confignode_list", null);
        if (addresses != null && !addresses.isEmpty()) {
            try {
                conf.setConfigNodeList(NodeUrlUtils.parseTConfigNodeUrls((String)addresses));
            }
            catch (BadNodeUrlException e) {
                throw new StartupException("Parse ConfigNodeList failed: {}", e.getMessage());
            }
        }
    }

    private void createDirIfEmpty(File dir) throws IOException {
        if (!dir.exists()) {
            if (dir.mkdirs()) {
                LOGGER.info("Make dirs: {}", (Object)dir);
            } else {
                throw new IOException(String.format("Start ConfigNode failed, because couldn't make system dirs: %s.", dir.getAbsolutePath()));
            }
        }
    }

    public static ConfigNodeStartupCheck getInstance() {
        return ConfigNodeConfCheckHolder.INSTANCE;
    }

    private static class ConfigNodeConfCheckHolder {
        private static final ConfigNodeStartupCheck INSTANCE = new ConfigNodeStartupCheck();

        private ConfigNodeConfCheckHolder() {
        }
    }
}

