/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.confignode.conf;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.util.List;
import java.util.Properties;
import org.apache.iotdb.common.rpc.thrift.TConfigNodeLocation;
import org.apache.iotdb.common.rpc.thrift.TEndPoint;
import org.apache.iotdb.common.rpc.thrift.TSStatus;
import org.apache.iotdb.commons.exception.BadNodeUrlException;
import org.apache.iotdb.commons.utils.NodeUrlUtils;
import org.apache.iotdb.confignode.client.SyncConfigNodeClientPool;
import org.apache.iotdb.confignode.conf.ConfigNodeConfig;
import org.apache.iotdb.confignode.conf.ConfigNodeDescriptor;
import org.apache.iotdb.confignode.conf.ConfigNodeStartupCheck;
import org.apache.iotdb.rpc.TSStatusCode;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ConfigNodeRemoveCheck {
    private static final Logger LOGGER = LoggerFactory.getLogger(ConfigNodeStartupCheck.class);
    private static final ConfigNodeConfig conf = ConfigNodeDescriptor.getInstance().getConf();
    private final File systemPropertiesFile = new File(conf.getSystemDir() + File.separator + "confignode-system.properties");
    private final Properties systemProperties = new Properties();

    public TConfigNodeLocation removeCheck(TEndPoint endPoint) {
        TConfigNodeLocation nodeLocation = new TConfigNodeLocation();
        if (!this.systemPropertiesFile.exists()) {
            LOGGER.error("The system properties file is not exists. IoTDB-ConfigNode is shutdown.");
            return nodeLocation;
        }
        try (FileInputStream inputStream = new FileInputStream(this.systemPropertiesFile);){
            this.systemProperties.load(inputStream);
            nodeLocation = this.getConfigNodeList().stream().filter(e -> e.getInternalEndPoint().equals(endPoint)).findFirst().get();
        }
        catch (IOException | BadNodeUrlException e2) {
            LOGGER.error("Load system properties file failed.", e2);
        }
        return nodeLocation;
    }

    public void removeConfigNode(TConfigNodeLocation nodeLocation) throws BadNodeUrlException, IOException {
        TSStatus status = SyncConfigNodeClientPool.getInstance().removeConfigNode(this.getConfigNodeList(), nodeLocation);
        if (status.getCode() != TSStatusCode.SUCCESS_STATUS.getStatusCode()) {
            LOGGER.error(status.getMessage());
            throw new IOException("Remove ConfigNode failed:");
        }
    }

    public List<TConfigNodeLocation> getConfigNodeList() throws BadNodeUrlException {
        return NodeUrlUtils.parseTConfigNodeUrls((String)this.systemProperties.getProperty("confignode_list"));
    }

    public int getConsensusPort() {
        return Integer.parseInt(this.systemProperties.getProperty("consensus_port"));
    }

    public static ConfigNodeRemoveCheck getInstance() {
        return ConfigNodeConfRemoveCheckHolder.INSTANCE;
    }

    private static class ConfigNodeConfRemoveCheckHolder {
        private static final ConfigNodeRemoveCheck INSTANCE = new ConfigNodeRemoveCheck();

        private ConfigNodeConfRemoveCheckHolder() {
        }
    }
}

