/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.confignode.conf;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Properties;
import org.apache.iotdb.commons.conf.CommonDescriptor;
import org.apache.iotdb.commons.exception.BadNodeUrlException;
import org.apache.iotdb.commons.utils.NodeUrlUtils;
import org.apache.iotdb.confignode.conf.ConfigNodeConfig;
import org.apache.iotdb.metrics.config.MetricConfigDescriptor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ConfigNodeDescriptor {
    private static final Logger LOGGER = LoggerFactory.getLogger(ConfigNodeDescriptor.class);
    private final CommonDescriptor commonDescriptor = CommonDescriptor.getInstance();
    private final ConfigNodeConfig conf = new ConfigNodeConfig();

    private ConfigNodeDescriptor() {
        this.loadProps();
    }

    public ConfigNodeConfig getConf() {
        return this.conf;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public URL getPropsUrl() {
        String urlString = System.getProperty("CONFIGNODE_CONF", null);
        if (urlString == null) {
            urlString = System.getProperty("CONFIGNODE_HOME", null);
            if (urlString == null) return null;
            urlString = urlString + File.separatorChar + "conf" + File.separatorChar + "iotdb-confignode.properties";
        } else if (!urlString.endsWith(".properties")) {
            urlString = urlString + File.separatorChar + "iotdb-confignode.properties";
        }
        if (!urlString.startsWith("file:") && !urlString.startsWith("classpath:")) {
            urlString = "file:" + urlString;
        }
        try {
            return new URL(urlString);
        }
        catch (MalformedURLException e) {
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void loadProps() {
        URL url = this.getPropsUrl();
        if (url == null) {
            LOGGER.warn("Couldn't load the ConfigNode configuration from any of the known sources. Use default configuration.");
            return;
        }
        try (InputStream inputStream = url.openStream();){
            LOGGER.info("start reading ConfigNode conf file: {}", (Object)url);
            Properties properties = new Properties();
            properties.load(inputStream);
            this.conf.setRpcAddress(properties.getProperty("rpc_address", this.conf.getRpcAddress()));
            this.conf.setRpcPort(Integer.parseInt(properties.getProperty("rpc_port", String.valueOf(this.conf.getRpcPort()))));
            this.conf.setConsensusPort(Integer.parseInt(properties.getProperty("consensus_port", String.valueOf(this.conf.getConsensusPort()))));
            String targetConfigNodes = properties.getProperty("target_config_nodes", null);
            if (targetConfigNodes != null) {
                this.conf.setTargetConfigNode(NodeUrlUtils.parseTEndPointUrl((String)targetConfigNodes));
            }
            this.conf.setSeriesPartitionSlotNum(Integer.parseInt(properties.getProperty("series_partition_slot_num", String.valueOf(this.conf.getSeriesPartitionSlotNum()))));
            this.conf.setSeriesPartitionExecutorClass(properties.getProperty("series_partition_executor_class", this.conf.getSeriesPartitionExecutorClass()));
            this.conf.setConfigNodeConsensusProtocolClass(properties.getProperty("config_node_consensus_protocol_class", this.conf.getConfigNodeConsensusProtocolClass()));
            this.conf.setSchemaRegionConsensusProtocolClass(properties.getProperty("schema_region_consensus_protocol_class", this.conf.getSchemaRegionConsensusProtocolClass()));
            this.conf.setSchemaRegionPerDataNode(Double.parseDouble(properties.getProperty("schema_region_per_data_node", String.valueOf(this.conf.getSchemaRegionPerDataNode()))));
            this.conf.setDataRegionConsensusProtocolClass(properties.getProperty("data_region_consensus_protocol_class", this.conf.getDataRegionConsensusProtocolClass()));
            this.conf.setDataRegionPerProcessor(Double.parseDouble(properties.getProperty("data_region_per_processor", String.valueOf(this.conf.getDataRegionPerProcessor()))));
            this.conf.setRpcAdvancedCompressionEnable(Boolean.parseBoolean(properties.getProperty("rpc_advanced_compression_enable", String.valueOf(this.conf.isRpcAdvancedCompressionEnable()))));
            this.conf.setRpcThriftCompressionEnabled(Boolean.parseBoolean(properties.getProperty("rpc_thrift_compression_enable", String.valueOf(this.conf.isRpcThriftCompressionEnabled()))));
            this.conf.setRpcMaxConcurrentClientNum(Integer.parseInt(properties.getProperty("rpc_max_concurrent_client_num", String.valueOf(this.conf.getRpcMaxConcurrentClientNum()))));
            this.conf.setThriftDefaultBufferSize(Integer.parseInt(properties.getProperty("thrift_init_buffer_size", String.valueOf(this.conf.getThriftDefaultBufferSize()))));
            this.conf.setThriftMaxFrameSize(Integer.parseInt(properties.getProperty("thrift_max_frame_size", String.valueOf(this.conf.getThriftMaxFrameSize()))));
            this.conf.setConnectionTimeoutInMS(Integer.parseInt(properties.getProperty("connection_timeout_ms", String.valueOf(this.conf.getConnectionTimeoutInMS()))));
            this.conf.setSelectorNumOfClientManager(Integer.parseInt(properties.getProperty("selector_thread_nums_of_client_manager", String.valueOf(this.conf.getSelectorNumOfClientManager()))));
            this.conf.setSystemDir(properties.getProperty("system_dir", this.conf.getSystemDir()));
            this.conf.setConsensusDir(properties.getProperty("consensus_dir", this.conf.getConsensusDir()));
            this.conf.setUdfLibDir(properties.getProperty("udf_lib_dir", this.conf.getUdfLibDir()));
            this.conf.setTemporaryLibDir(properties.getProperty("temporary_lib_dir", this.conf.getTemporaryLibDir()));
            this.conf.setTimePartitionInterval(Long.parseLong(properties.getProperty("time_partition_interval", String.valueOf(this.conf.getTimePartitionInterval()))));
            this.conf.setSchemaReplicationFactor(Integer.parseInt(properties.getProperty("schema_replication_factor", String.valueOf(this.conf.getSchemaReplicationFactor()))));
            this.conf.setDataReplicationFactor(Integer.parseInt(properties.getProperty("data_replication_factor", String.valueOf(this.conf.getDataReplicationFactor()))));
            this.conf.setHeartbeatInterval(Long.parseLong(properties.getProperty("heartbeat_interval", String.valueOf(this.conf.getHeartbeatInterval()))));
            this.commonDescriptor.loadCommonProps(properties);
            this.commonDescriptor.initCommonConfigDir(this.conf.getSystemDir());
            this.conf.setProcedureCompletedEvictTTL(Integer.parseInt(properties.getProperty("procedure_completed_evict_ttl", String.valueOf(this.conf.getProcedureCompletedEvictTTL()))));
            this.conf.setProcedureCompletedCleanInterval(Integer.parseInt(properties.getProperty("procedure_completed_clean_interval", String.valueOf(this.conf.getProcedureCompletedCleanInterval()))));
            this.conf.setProcedureCoreWorkerThreadsSize(Integer.parseInt(properties.getProperty("procedure_core_worker_thread_size", String.valueOf(this.conf.getProcedureCoreWorkerThreadsSize()))));
        }
        catch (IOException | BadNodeUrlException e) {
            LOGGER.warn("Couldn't load ConfigNode conf file, use default config", e);
        }
        finally {
            this.conf.updatePath();
            this.commonDescriptor.getConfig().updatePath(System.getProperty("CONFIGNODE_HOME", null));
            MetricConfigDescriptor.getInstance().getMetricConfig().updateRpcInstance(this.conf.getRpcAddress(), this.conf.getRpcPort());
        }
    }

    public static ConfigNodeDescriptor getInstance() {
        return ConfigNodeDescriptorHolder.INSTANCE;
    }

    private static class ConfigNodeDescriptorHolder {
        private static final ConfigNodeDescriptor INSTANCE = new ConfigNodeDescriptor();

        private ConfigNodeDescriptorHolder() {
        }
    }
}

