/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.commons.client.sync;

import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.net.SocketException;
import net.sf.cglib.proxy.Callback;
import net.sf.cglib.proxy.Enhancer;
import net.sf.cglib.proxy.MethodInterceptor;
import net.sf.cglib.proxy.MethodProxy;
import org.apache.commons.lang3.exception.ExceptionUtils;
import org.apache.iotdb.commons.client.sync.SyncThriftClient;
import org.apache.thrift.TException;
import org.apache.thrift.transport.TTransportException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SyncThriftClientWithErrorHandler
implements MethodInterceptor {
    private static final Logger LOGGER = LoggerFactory.getLogger(SyncThriftClientWithErrorHandler.class);

    public static <V extends SyncThriftClient> V newErrorHandler(Class<V> targetClass, Constructor<V> constructor, Object ... args) {
        Enhancer enhancer = new Enhancer();
        enhancer.setSuperclass(targetClass);
        enhancer.setCallback((Callback)new SyncThriftClientWithErrorHandler());
        if (constructor == null) {
            return (V)((SyncThriftClient)enhancer.create());
        }
        return (V)((SyncThriftClient)enhancer.create((Class[])constructor.getParameterTypes(), args));
    }

    public Object intercept(Object o, Method method, Object[] objects, MethodProxy methodProxy) throws Throwable {
        try {
            return methodProxy.invokeSuper(o, objects);
        }
        catch (Throwable t) {
            Throwable rootCause;
            Throwable cur;
            Throwable origin = t;
            if (t instanceof InvocationTargetException) {
                origin = ((InvocationTargetException)t).getTargetException();
            }
            if ((cur = origin) instanceof TException) {
                int level = 0;
                while (cur != null) {
                    LOGGER.error("level-{} Exception class {}, message {}", new Object[]{level, cur.getClass().getName(), cur.getMessage()});
                    cur = cur.getCause();
                    ++level;
                }
                ((SyncThriftClient)o).invalidate();
            }
            if ((rootCause = ExceptionUtils.getRootCause((Throwable)origin)) != null) {
                LOGGER.error("root cause message {}, LocalizedMessage {}, ", new Object[]{rootCause.getMessage(), rootCause.getLocalizedMessage(), rootCause});
                if (this.isConnectionBroken(rootCause)) {
                    LOGGER.error("Broken pipe error happened in calling method {}, we need to clear all previous cached connection, err: {}", (Object)method.getName(), (Object)t);
                    ((SyncThriftClient)o).invalidate();
                    ((SyncThriftClient)o).invalidateAll();
                }
            }
            throw new TException("Error in calling method " + method.getName(), t);
        }
    }

    private boolean isConnectionBroken(Throwable cause) {
        return cause instanceof SocketException && cause.getMessage().contains("Broken pipe") || cause instanceof TTransportException && cause.getMessage().contains("Socket is closed by peer");
    }
}

