/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.tsfile.read.common.block.column;

import java.io.DataOutputStream;
import java.io.IOException;
import java.nio.ByteBuffer;
import org.apache.iotdb.tsfile.file.metadata.enums.TSDataType;
import org.apache.iotdb.tsfile.read.common.block.column.BooleanColumnBuilder;
import org.apache.iotdb.tsfile.read.common.block.column.Column;
import org.apache.iotdb.tsfile.read.common.block.column.ColumnEncoder;

public class ByteArrayColumnEncoder
implements ColumnEncoder {
    @Override
    public Column readColumn(ByteBuffer input, TSDataType dataType, int positionCount) {
        boolean[] nullIndicators = ColumnEncoder.deserializeNullIndicators(input, positionCount);
        if (TSDataType.BOOLEAN.equals((Object)dataType)) {
            BooleanColumnBuilder columnBuilder = new BooleanColumnBuilder(null, positionCount);
            boolean[] values = ColumnEncoder.deserializeBooleanArray(input, positionCount);
            for (int i = 0; i < positionCount; ++i) {
                if (nullIndicators == null || !nullIndicators[i]) {
                    columnBuilder.writeBoolean(values[i]);
                    continue;
                }
                columnBuilder.appendNull();
            }
            return columnBuilder.build();
        }
        throw new IllegalArgumentException("Invalid data type: " + (Object)((Object)dataType));
    }

    @Override
    public void writeColumn(DataOutputStream output, Column column) throws IOException {
        ColumnEncoder.serializeNullIndicators(output, column);
        TSDataType dataType = column.getDataType();
        if (!TSDataType.BOOLEAN.equals((Object)dataType)) {
            throw new IllegalArgumentException("Invalid data type: " + (Object)((Object)dataType));
        }
        ColumnEncoder.serializeBooleanArray(output, column, Column::getBoolean);
    }
}

