/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.metrics.dropwizard.reporter;

import com.codahale.metrics.Counter;
import com.codahale.metrics.Gauge;
import com.codahale.metrics.Histogram;
import com.codahale.metrics.Meter;
import com.codahale.metrics.Metered;
import com.codahale.metrics.Metric;
import com.codahale.metrics.MetricRegistry;
import com.codahale.metrics.Snapshot;
import com.codahale.metrics.Timer;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import org.apache.iotdb.metrics.dropwizard.MetricName;
import org.apache.iotdb.metrics.dropwizard.reporter.MetricType;
import org.apache.iotdb.metrics.dropwizard.reporter.PrometheusTextWriter;

class DropwizardMetricsExporter {
    private final MetricRegistry metricRegistry;
    private final PrometheusTextWriter writer;

    public DropwizardMetricsExporter(MetricRegistry metricRegistry, PrometheusTextWriter writer) {
        this.metricRegistry = metricRegistry;
        this.writer = writer;
    }

    public void scrape() throws IOException {
        for (Map.Entry entry : this.metricRegistry.getGauges().entrySet()) {
            this.writeGauge((String)entry.getKey(), (Gauge)entry.getValue());
        }
        for (Map.Entry entry : this.metricRegistry.getCounters().entrySet()) {
            this.writeCounter((String)entry.getKey(), (Counter)entry.getValue());
        }
        for (Map.Entry entry : this.metricRegistry.getHistograms().entrySet()) {
            this.writeHistogram((String)entry.getKey(), (Histogram)entry.getValue());
        }
        for (Map.Entry entry : this.metricRegistry.getMeters().entrySet()) {
            this.writeMeter((String)entry.getKey(), (Meter)entry.getValue());
        }
        for (Map.Entry entry : this.metricRegistry.getTimers().entrySet()) {
            this.writeTimer((String)entry.getKey(), (Timer)entry.getValue());
        }
    }

    public void writeGauge(String dropwizardName, Gauge<?> gauge) throws IOException {
        double value;
        MetricName metricName = new MetricName(dropwizardName);
        String sanitizeName = metricName.getName();
        this.writer.writeHelp(sanitizeName, DropwizardMetricsExporter.getHelpMessage(dropwizardName, gauge));
        this.writer.writeType(sanitizeName, MetricType.GAUGE);
        Object obj = gauge.getValue();
        if (obj instanceof Number) {
            value = ((Number)obj).doubleValue();
        } else if (obj instanceof Boolean) {
            value = (Boolean)obj != false ? 1.0 : 0.0;
        } else {
            return;
        }
        this.writer.writeSample(sanitizeName, metricName.getTags(), value);
    }

    public void writeCounter(String dropwizardName, Counter counter) throws IOException {
        MetricName metricName = new MetricName(dropwizardName);
        String sanitizeName = metricName.getName();
        this.writer.writeHelp(sanitizeName, DropwizardMetricsExporter.getHelpMessage(dropwizardName, (Metric)counter));
        this.writer.writeType(sanitizeName, MetricType.GAUGE);
        this.writer.writeSample(sanitizeName, metricName.getTags(), counter.getCount());
    }

    public void writeHistogram(String dropwizardName, Histogram histogram) throws IOException {
        this.writeSnapshotAndCount(new MetricName(dropwizardName), histogram.getSnapshot(), histogram.getCount(), 1.0, DropwizardMetricsExporter.getHelpMessage(dropwizardName, (Metric)histogram));
    }

    private void writeSnapshotAndCount(MetricName metricName, Snapshot snapshot, long count, double factor, String helpMessage) throws IOException {
        String sanitizeName = metricName.getName();
        this.writer.writeHelp(sanitizeName, helpMessage);
        this.writer.writeType(sanitizeName, MetricType.SUMMARY);
        Map<String, String> tags = metricName.getTags();
        this.writer.writeSample(sanitizeName, this.addTags(tags, "quantile", "0.5"), snapshot.getMedian() * factor);
        this.writer.writeSample(sanitizeName, this.addTags(tags, "quantile", "0.75"), snapshot.get75thPercentile() * factor);
        this.writer.writeSample(sanitizeName, this.addTags(tags, "quantile", "0.95"), snapshot.get95thPercentile() * factor);
        this.writer.writeSample(sanitizeName, this.addTags(tags, "quantile", "0.98"), snapshot.get98thPercentile() * factor);
        this.writer.writeSample(sanitizeName, this.addTags(tags, "quantile", "0.99"), snapshot.get99thPercentile() * factor);
        this.writer.writeSample(sanitizeName, this.addTags(tags, "quantile", "0.999"), snapshot.get999thPercentile() * factor);
        this.writer.writeSample(sanitizeName + "_min", tags, snapshot.getMin());
        this.writer.writeSample(sanitizeName + "_max", tags, snapshot.getMax());
        this.writer.writeSample(sanitizeName + "_median", tags, snapshot.getMedian());
        this.writer.writeSample(sanitizeName + "_mean", tags, snapshot.getMean());
        this.writer.writeSample(sanitizeName + "_stddev", tags, snapshot.getStdDev());
        this.writer.writeSample(sanitizeName + "_count", tags, count);
    }

    public void writeTimer(String dropwizardName, Timer timer) throws IOException {
        this.writeSnapshotAndCount(new MetricName(dropwizardName), timer.getSnapshot(), timer.getCount(), 1.0 / (double)TimeUnit.SECONDS.toNanos(1L), DropwizardMetricsExporter.getHelpMessage(dropwizardName, (Metric)timer));
        this.writeMetered(new MetricName(dropwizardName), (Metered)timer);
    }

    public void writeMeter(String dropwizardName, Meter meter) throws IOException {
        MetricName metricName = new MetricName(dropwizardName);
        String sanitizeName = metricName.getName() + "_total";
        this.writer.writeHelp(sanitizeName, DropwizardMetricsExporter.getHelpMessage(dropwizardName, (Metric)meter));
        this.writer.writeType(sanitizeName, MetricType.COUNTER);
        this.writer.writeSample(sanitizeName, metricName.getTags(), meter.getCount());
        this.writeMetered(new MetricName(dropwizardName), (Metered)meter);
    }

    private void writeMetered(MetricName metricName, Metered metered) throws IOException {
        String sanitizeName = metricName.getName();
        Map<String, String> tags = metricName.getTags();
        this.writer.writeSample(sanitizeName, this.addTags(tags, "rate", "m1"), metered.getOneMinuteRate());
        this.writer.writeSample(sanitizeName, this.addTags(tags, "rate", "m5"), metered.getFiveMinuteRate());
        this.writer.writeSample(sanitizeName, this.addTags(tags, "rate", "m15"), metered.getFifteenMinuteRate());
        this.writer.writeSample(sanitizeName, this.addTags(tags, "rate", "mean"), metered.getMeanRate());
    }

    private Map<String, String> addTags(Map<String, String> tags, String key, String value) {
        HashMap<String, String> result = new HashMap<String, String>(tags);
        result.put(key, value);
        return result;
    }

    private static String getHelpMessage(String metricName, Metric metric) {
        return String.format("Generated from Dropwizard metric import (metric=%s, type=%s)", metricName, metric.getClass().getName());
    }
}

