/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.consensus.multileader.service;

import java.lang.reflect.InvocationTargetException;
import org.apache.iotdb.common.rpc.thrift.TEndPoint;
import org.apache.iotdb.commons.concurrent.ThreadName;
import org.apache.iotdb.commons.exception.runtime.RPCServiceException;
import org.apache.iotdb.commons.service.ServiceType;
import org.apache.iotdb.commons.service.ThriftService;
import org.apache.iotdb.commons.service.ThriftServiceThread;
import org.apache.iotdb.consensus.config.MultiLeaderConfig;
import org.apache.iotdb.consensus.multileader.service.MultiLeaderRPCServiceHandler;
import org.apache.iotdb.consensus.multileader.service.MultiLeaderRPCServiceMBean;
import org.apache.iotdb.consensus.multileader.service.MultiLeaderRPCServiceProcessor;
import org.apache.iotdb.consensus.multileader.thrift.MultiLeaderConsensusIService;
import org.apache.thrift.server.TServerEventHandler;

public class MultiLeaderRPCService
extends ThriftService
implements MultiLeaderRPCServiceMBean {
    private final TEndPoint thisNode;
    private final MultiLeaderConfig config;
    private MultiLeaderRPCServiceProcessor multiLeaderRPCServiceProcessor;

    public MultiLeaderRPCService(TEndPoint thisNode, MultiLeaderConfig config) {
        this.thisNode = thisNode;
        this.config = config;
    }

    public ServiceType getID() {
        return ServiceType.MULTI_LEADER_CONSENSUS_SERVICE;
    }

    public void initSyncedServiceImpl(Object multiLeaderRPCServiceProcessor) {
        this.multiLeaderRPCServiceProcessor = (MultiLeaderRPCServiceProcessor)multiLeaderRPCServiceProcessor;
        this.mbeanName = String.format("%s:%s=%s", this.getClass().getPackage(), "type", this.getID().getJmxName());
        super.initSyncedServiceImpl((Object)this.multiLeaderRPCServiceProcessor);
    }

    public void initTProcessor() throws ClassNotFoundException, IllegalAccessException, InstantiationException, NoSuchMethodException, InvocationTargetException {
        this.processor = new MultiLeaderConsensusIService.Processor((MultiLeaderConsensusIService.Iface)this.multiLeaderRPCServiceProcessor);
    }

    public void initThriftServiceThread() throws IllegalAccessException, InstantiationException, ClassNotFoundException {
        try {
            this.thriftServiceThread = new ThriftServiceThread(this.processor, this.getID().getName(), ThreadName.MULTI_LEADER_CONSENSUS_RPC_CLIENT.getName(), this.getBindIP(), this.getBindPort(), this.config.getRpc().getRpcMaxConcurrentClientNum(), this.config.getRpc().getThriftServerAwaitTimeForStopService(), (TServerEventHandler)new MultiLeaderRPCServiceHandler(this.multiLeaderRPCServiceProcessor), this.config.getRpc().isRpcThriftCompressionEnabled());
        }
        catch (RPCServiceException e) {
            throw new IllegalAccessException(e.getMessage());
        }
        this.thriftServiceThread.setName(ThreadName.MULTI_LEADER_CONSENSUS_RPC_SERVER.getName());
    }

    public String getBindIP() {
        return this.thisNode.getIp();
    }

    public int getBindPort() {
        return this.thisNode.getPort();
    }
}

