/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.consensus.multileader.logdispatcher;

import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.attribute.FileAttribute;
import javax.annotation.concurrent.ThreadSafe;
import org.apache.commons.io.FileUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ThreadSafe
public class IndexController {
    private final Logger logger = LoggerFactory.getLogger(IndexController.class);
    public static final int FLUSH_INTERVAL = 500;
    private volatile long lastFlushedIndex;
    private volatile long currentIndex;
    private final String storageDir;
    private final String prefix;
    private final boolean incrementIntervalAfterRestart;

    public IndexController(String storageDir, String prefix, boolean incrementIntervalAfterRestart) {
        this.storageDir = storageDir;
        this.prefix = prefix + '-';
        this.incrementIntervalAfterRestart = incrementIntervalAfterRestart;
        this.restore();
    }

    public synchronized long incrementAndGet() {
        ++this.currentIndex;
        this.checkPersist();
        return this.currentIndex;
    }

    public synchronized long updateAndGet(long index) {
        long newCurrentIndex = Math.max(this.currentIndex, index);
        this.logger.debug("update index from currentIndex {} to {} for file prefix {} in {}", new Object[]{this.currentIndex, newCurrentIndex, this.prefix, this.storageDir});
        this.currentIndex = newCurrentIndex;
        this.checkPersist();
        return this.currentIndex;
    }

    public long getCurrentIndex() {
        return this.currentIndex;
    }

    public long getLastFlushedIndex() {
        return this.lastFlushedIndex;
    }

    private void checkPersist() {
        if (this.currentIndex - this.lastFlushedIndex >= 500L) {
            this.persist();
        }
    }

    private void persist() {
        long flushIndex = this.currentIndex - this.currentIndex % 500L;
        File oldFile = new File(this.storageDir, this.prefix + this.lastFlushedIndex);
        File newFile = new File(this.storageDir, this.prefix + flushIndex);
        try {
            if (oldFile.exists()) {
                FileUtils.moveFile((File)oldFile, (File)newFile);
            }
            this.logger.info("Version file updated, previous: {}, current: {}", (Object)oldFile.getAbsolutePath(), (Object)newFile.getAbsolutePath());
            this.lastFlushedIndex = flushIndex;
        }
        catch (IOException e) {
            this.logger.error("Error occurred when flushing next version", (Throwable)e);
        }
    }

    private void restore() {
        File directory = new File(this.storageDir);
        File[] versionFiles = directory.listFiles((dir, name) -> name.startsWith(this.prefix));
        if (versionFiles != null && versionFiles.length > 0) {
            int i;
            long maxVersion = 0L;
            int maxVersionIndex = 0;
            for (i = 0; i < versionFiles.length; ++i) {
                long fileVersion = Long.parseLong(versionFiles[i].getName().split("-")[1]);
                if (fileVersion <= maxVersion) continue;
                maxVersion = fileVersion;
                maxVersionIndex = i;
            }
            this.lastFlushedIndex = maxVersion;
            for (i = 0; i < versionFiles.length; ++i) {
                if (i == maxVersionIndex) continue;
                try {
                    Files.delete(versionFiles[i].toPath());
                    continue;
                }
                catch (IOException e) {
                    this.logger.error("Delete outdated version file {} failed", (Object)versionFiles[i].getAbsolutePath(), (Object)e);
                }
            }
            if (this.incrementIntervalAfterRestart) {
                this.currentIndex = this.lastFlushedIndex + 500L;
                this.persist();
            } else {
                this.currentIndex = this.lastFlushedIndex;
            }
        } else {
            File versionFile = new File(directory, this.prefix + "0");
            try {
                Files.createFile(versionFile.toPath(), new FileAttribute[0]);
            }
            catch (IOException e) {
                this.logger.error("Error occurred when creating new file {}", (Object)versionFile.getAbsolutePath(), (Object)e);
            }
        }
    }
}

