/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.consensus.multileader;

import java.io.DataOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Paths;
import java.util.List;
import org.apache.iotdb.common.rpc.thrift.TEndPoint;
import org.apache.iotdb.common.rpc.thrift.TSStatus;
import org.apache.iotdb.commons.client.IClientManager;
import org.apache.iotdb.consensus.IStateMachine;
import org.apache.iotdb.consensus.common.DataSet;
import org.apache.iotdb.consensus.common.Peer;
import org.apache.iotdb.consensus.common.request.ByteBufferConsensusRequest;
import org.apache.iotdb.consensus.common.request.IConsensusRequest;
import org.apache.iotdb.consensus.common.request.IndexedConsensusRequest;
import org.apache.iotdb.consensus.config.MultiLeaderConfig;
import org.apache.iotdb.consensus.multileader.client.AsyncMultiLeaderServiceClient;
import org.apache.iotdb.consensus.multileader.logdispatcher.IndexController;
import org.apache.iotdb.consensus.multileader.logdispatcher.LogDispatcher;
import org.apache.iotdb.consensus.ratis.Utils;
import org.apache.iotdb.tsfile.utils.PublicBAOS;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MultiLeaderServerImpl {
    private static final String CONFIGURATION_FILE_NAME = "configuration.dat";
    private final Logger logger = LoggerFactory.getLogger(MultiLeaderServerImpl.class);
    private final Peer thisNode;
    private final IStateMachine stateMachine;
    private final String storageDir;
    private final List<Peer> configuration;
    private final IndexController controller;
    private final LogDispatcher logDispatcher;
    private final MultiLeaderConfig config;

    public MultiLeaderServerImpl(String storageDir, Peer thisNode, List<Peer> configuration, IStateMachine stateMachine, IClientManager<TEndPoint, AsyncMultiLeaderServiceClient> clientManager, MultiLeaderConfig config) {
        this.storageDir = storageDir;
        this.thisNode = thisNode;
        this.stateMachine = stateMachine;
        this.controller = new IndexController(storageDir, Utils.fromTEndPointToString(thisNode.getEndpoint()), true);
        this.configuration = configuration;
        if (configuration.isEmpty()) {
            this.recoverConfiguration();
        } else {
            this.persistConfiguration();
        }
        this.config = config;
        this.logDispatcher = new LogDispatcher(this, clientManager);
    }

    public IStateMachine getStateMachine() {
        return this.stateMachine;
    }

    public void start() {
        this.stateMachine.start();
        this.logDispatcher.start();
    }

    public void stop() {
        this.logDispatcher.stop();
        this.stateMachine.stop();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public TSStatus write(IConsensusRequest request) {
        IStateMachine iStateMachine = this.stateMachine;
        synchronized (iStateMachine) {
            IndexedConsensusRequest indexedConsensusRequest = this.buildIndexedConsensusRequestForLocalRequest(request);
            TSStatus result = this.stateMachine.write(indexedConsensusRequest);
            this.logDispatcher.offer(indexedConsensusRequest);
            return result;
        }
    }

    public DataSet read(IConsensusRequest request) {
        return this.stateMachine.read(request);
    }

    public boolean takeSnapshot(File snapshotDir) {
        return this.stateMachine.takeSnapshot(snapshotDir);
    }

    public void loadSnapshot(File latestSnapshotRootDir) {
        this.stateMachine.loadSnapshot(latestSnapshotRootDir);
    }

    public void persistConfiguration() {
        try (PublicBAOS publicBAOS = new PublicBAOS();
             DataOutputStream outputStream = new DataOutputStream((OutputStream)publicBAOS);){
            outputStream.writeInt(this.configuration.size());
            for (Peer peer : this.configuration) {
                peer.serialize(outputStream);
            }
            Files.write(Paths.get(new File(this.storageDir, CONFIGURATION_FILE_NAME).getAbsolutePath(), new String[0]), publicBAOS.getBuf(), new OpenOption[0]);
        }
        catch (IOException e) {
            this.logger.error("Unexpected error occurs when persisting configuration", (Throwable)e);
        }
    }

    public void recoverConfiguration() {
        try {
            ByteBuffer buffer = ByteBuffer.wrap(Files.readAllBytes(Paths.get(new File(this.storageDir, CONFIGURATION_FILE_NAME).getAbsolutePath(), new String[0])));
            int size = buffer.getInt();
            for (int i = 0; i < size; ++i) {
                this.configuration.add(Peer.deserialize(buffer));
            }
        }
        catch (IOException e) {
            this.logger.error("Unexpected error occurs when recovering configuration", (Throwable)e);
        }
    }

    public IndexedConsensusRequest buildIndexedConsensusRequestForLocalRequest(IConsensusRequest request) {
        return new IndexedConsensusRequest(this.controller.incrementAndGet(), this.getCurrentSafelyDeletedSearchIndex(), request);
    }

    public IndexedConsensusRequest buildIndexedConsensusRequestForRemoteRequest(ByteBufferConsensusRequest request) {
        return new IndexedConsensusRequest(-1L, this.getCurrentSafelyDeletedSearchIndex(), request);
    }

    public long getCurrentSafelyDeletedSearchIndex() {
        return this.logDispatcher.getMinSyncIndex().orElseGet(this.controller::getCurrentIndex);
    }

    public String getStorageDir() {
        return this.storageDir;
    }

    public Peer getThisNode() {
        return this.thisNode;
    }

    public List<Peer> getConfiguration() {
        return this.configuration;
    }

    public IndexController getController() {
        return this.controller;
    }

    public MultiLeaderConfig getConfig() {
        return this.config;
    }
}

