/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.utils.writelog;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.ClosedChannelException;
import java.nio.channels.FileChannel;
import java.util.zip.CRC32;
import org.apache.iotdb.commons.file.SystemFileFactory;
import org.apache.iotdb.db.utils.writelog.ILogWriter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LogWriter
implements ILogWriter {
    private static final Logger logger = LoggerFactory.getLogger(LogWriter.class);
    private File logFile;
    private FileOutputStream fileOutputStream;
    private FileChannel channel;
    private final CRC32 checkSummer = new CRC32();
    private final ByteBuffer lengthBuffer = ByteBuffer.allocate(4);
    private final ByteBuffer checkSumBuffer = ByteBuffer.allocate(8);
    private final boolean forceEachWrite;

    public LogWriter(String logFilePath, boolean forceEachWrite) throws FileNotFoundException {
        this.logFile = SystemFileFactory.INSTANCE.getFile(logFilePath);
        this.forceEachWrite = forceEachWrite;
        this.fileOutputStream = new FileOutputStream(this.logFile, true);
        this.channel = this.fileOutputStream.getChannel();
    }

    public LogWriter(File logFile, boolean forceEachWrite) throws FileNotFoundException {
        this.logFile = logFile;
        this.forceEachWrite = forceEachWrite;
        this.fileOutputStream = new FileOutputStream(logFile, true);
        this.channel = this.fileOutputStream.getChannel();
    }

    @Override
    public void write(ByteBuffer logBuffer) throws IOException {
        if (this.channel == null) {
            this.fileOutputStream = new FileOutputStream(this.logFile, true);
            this.channel = this.fileOutputStream.getChannel();
        }
        logBuffer.flip();
        int logSize = logBuffer.limit();
        this.checkSummer.reset();
        this.checkSummer.update(logBuffer);
        long checkSum = this.checkSummer.getValue();
        logBuffer.flip();
        this.lengthBuffer.clear();
        this.checkSumBuffer.clear();
        this.lengthBuffer.putInt(logSize);
        this.checkSumBuffer.putLong(checkSum);
        this.lengthBuffer.flip();
        this.checkSumBuffer.flip();
        try {
            this.channel.write(this.lengthBuffer);
            this.channel.write(logBuffer);
            this.channel.write(this.checkSumBuffer);
            if (this.forceEachWrite) {
                this.channel.force(true);
            }
        }
        catch (ClosedChannelException ignored) {
            logger.warn("someone interrupt current thread, so no need to do write for io safety");
        }
    }

    @Override
    public void force() throws IOException {
        if (this.channel != null && this.channel.isOpen()) {
            this.channel.force(true);
        }
    }

    @Override
    public void close() throws IOException {
        if (this.channel != null) {
            if (this.channel.isOpen()) {
                this.channel.force(true);
            }
            this.fileOutputStream.close();
            this.fileOutputStream = null;
            this.channel.close();
            this.channel = null;
        }
    }

    public String toString() {
        return "LogWriter{logFile=" + this.logFile + '}';
    }
}

