/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.sync.sender.service;

import java.util.ArrayDeque;
import java.util.Queue;
import org.apache.iotdb.db.qp.logical.Operator;
import org.apache.iotdb.db.sync.conf.SyncPathUtil;
import org.apache.iotdb.db.sync.sender.pipe.Pipe;
import org.apache.iotdb.db.sync.sender.recovery.SenderLogger;
import org.apache.iotdb.service.transport.thrift.ResponseType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MsgManager {
    private static final Logger logger = LoggerFactory.getLogger(MsgManager.class);
    private SenderLogger senderLogger;
    private Pipe runningPipe;
    private Queue<String> Messages;

    public MsgManager() {
    }

    public MsgManager(SenderLogger senderLogger) {
        this.senderLogger = senderLogger;
    }

    public void addPipe(Pipe pipe) {
        this.runningPipe = pipe;
        this.Messages = new ArrayDeque<String>();
    }

    public void removeAllPipe() {
        this.runningPipe = null;
        this.Messages = null;
    }

    public synchronized void recordMsg(Pipe pipe, Operator.OperatorType operatorType, ResponseType type, String inputMsg) {
        if (this.runningPipe == null) {
            logger.warn(String.format("No running Pipe for recording msg [%s] %s.", type.name(), inputMsg));
            return;
        }
        if (!pipe.equals(this.runningPipe)) {
            logger.warn(String.format("Input Pipe %s is not equal running Pipe %s, ignore it.", pipe.getName(), this.runningPipe.getName()));
        }
        String msg = String.format("[%s] ", type.name()) + SyncPathUtil.createMsg(inputMsg);
        if (this.Messages.size() > 1) {
            this.Messages.poll();
        }
        this.Messages.offer(msg);
        if (this.senderLogger != null) {
            this.senderLogger.recordMsg(pipe.getName(), operatorType, msg);
        }
    }

    public synchronized String getPipeMsg(Pipe pipe) {
        if (this.runningPipe == null) {
            return "";
        }
        if (!pipe.equals(this.runningPipe)) {
            return "";
        }
        StringBuilder builder = new StringBuilder();
        int size = this.Messages.size();
        for (int i = 0; i < size; ++i) {
            String msg = this.Messages.poll();
            if (i < 1) {
                builder.append(msg);
            }
            this.Messages.offer(msg);
        }
        if (size > 1) {
            builder.append(" ...");
        }
        return builder.toString();
    }

    public void recoverMsg(String[] parseStrings) {
        if (parseStrings.length == 3) {
            if (this.Messages.size() > 1) {
                this.Messages.poll();
            }
            this.Messages.offer(parseStrings[2]);
        }
    }
}

