/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.sync.receiver.recovery;

import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import org.apache.iotdb.db.sync.conf.SyncPathUtil;
import org.apache.iotdb.db.sync.receiver.manager.PipeMessage;
import org.apache.iotdb.db.sync.sender.pipe.Pipe;

public class ReceiverLog {
    private BufferedWriter pipeServerWriter;
    private BufferedWriter msgWriter;

    public void init() throws IOException {
        File logFile = new File(SyncPathUtil.getSysDir(), "receiverService.log");
        File msgFile = new File(SyncPathUtil.getSysDir(), "receiverMessage.log");
        if (!logFile.getParentFile().exists()) {
            logFile.getParentFile().mkdirs();
        }
        this.pipeServerWriter = new BufferedWriter(new FileWriter(logFile, true));
        this.msgWriter = new BufferedWriter(new FileWriter(msgFile, true));
    }

    public void startPipeServer() throws IOException {
        if (this.pipeServerWriter == null) {
            this.init();
        }
        this.pipeServerWriter.write("on");
        this.pipeServerWriter.newLine();
        this.pipeServerWriter.flush();
    }

    public void stopPipeServer() throws IOException {
        if (this.pipeServerWriter == null) {
            this.init();
        }
        this.pipeServerWriter.write("off");
        this.pipeServerWriter.newLine();
        this.pipeServerWriter.flush();
    }

    public void createPipe(String pipeName, String remoteIp, long time) throws IOException {
        this.writeLog(pipeName, remoteIp, time);
    }

    public void startPipe(String pipeName, String remoteIp, long time) throws IOException {
        this.writeLog(pipeName, remoteIp, Pipe.PipeStatus.RUNNING, time);
    }

    public void stopPipe(String pipeName, String remoteIp, long time) throws IOException {
        this.writeLog(pipeName, remoteIp, Pipe.PipeStatus.STOP, time);
    }

    public void dropPipe(String pipeName, String remoteIp, long time) throws IOException {
        this.writeLog(pipeName, remoteIp, Pipe.PipeStatus.DROP, time);
    }

    public void writePipeMsg(String pipeIdentifier, PipeMessage pipeMessage) throws IOException {
        if (this.msgWriter == null) {
            this.init();
        }
        this.msgWriter.write(String.format("%s,%s,%s", new Object[]{pipeIdentifier, pipeMessage.getType(), pipeMessage.getMsg()}));
        this.msgWriter.newLine();
        this.msgWriter.flush();
    }

    public void comsumePipeMsg(String pipeIdentifier) throws IOException {
        if (this.msgWriter == null) {
            this.init();
        }
        this.msgWriter.write(String.format("%s,read", pipeIdentifier));
        this.msgWriter.newLine();
        this.msgWriter.flush();
    }

    private void writeLog(String pipeName, String remoteIp, Pipe.PipeStatus status, long time) throws IOException {
        if (this.pipeServerWriter == null) {
            this.init();
        }
        this.pipeServerWriter.write(String.format("%s,%s,%d,%s", new Object[]{pipeName, remoteIp, time, status}));
        this.pipeServerWriter.newLine();
        this.pipeServerWriter.flush();
    }

    private void writeLog(String pipeName, String remoteIp, long time) throws IOException {
        if (this.pipeServerWriter == null) {
            this.init();
        }
        this.pipeServerWriter.write(String.format("%s,%s,%d", pipeName, remoteIp, time));
        this.pipeServerWriter.newLine();
        this.pipeServerWriter.flush();
    }

    public void close() throws IOException {
        if (this.pipeServerWriter != null) {
            this.pipeServerWriter.close();
            this.pipeServerWriter = null;
        }
        if (this.msgWriter != null) {
            this.msgWriter.close();
            this.msgWriter = null;
        }
    }
}

