/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.service;

import java.io.IOException;
import org.apache.iotdb.commons.ServerCommandLine;
import org.apache.iotdb.commons.exception.ConfigurationException;
import org.apache.iotdb.db.service.DataNode;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DataNodeServerCommandLine
extends ServerCommandLine {
    private static final Logger logger = LoggerFactory.getLogger(DataNodeServerCommandLine.class);
    private static final String MODE_START = "-s";
    private static final String MODE_REMOVE = "-r";
    private static final String USAGE = "Usage: <-s|-r> [-D{} <configure folder>] \n-s: start the node to the cluster\n-r: remove the node out of the cluster\n";

    protected String getUsage() {
        return USAGE;
    }

    protected int run(String[] args) {
        if (args.length < 1) {
            this.usage(null);
            return -1;
        }
        DataNode dataNode = DataNode.getInstance();
        try {
            dataNode.serverCheckAndInit();
        }
        catch (IOException | ConfigurationException e) {
            logger.error("meet error when doing start checking", e);
            return -1;
        }
        String mode = args[0];
        logger.info("Running mode {}", (Object)mode);
        if (!dataNode.initLocalEngines()) {
            logger.error("initLocalEngines error, stop process!");
            return -1;
        }
        if (MODE_START.equals(mode)) {
            dataNode.doAddNode(args);
        } else if (MODE_REMOVE.equals(mode)) {
            dataNode.doRemoveNode(args);
        } else {
            logger.error("Unrecognized mode {}", (Object)mode);
        }
        return 0;
    }
}

