/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.rescon;

import java.util.HashMap;
import java.util.Map;
import java.util.PriorityQueue;
import java.util.concurrent.ExecutorService;
import org.apache.iotdb.commons.concurrent.IoTDBThreadPoolFactory;
import org.apache.iotdb.db.conf.IoTDBConfig;
import org.apache.iotdb.db.conf.IoTDBDescriptor;
import org.apache.iotdb.db.engine.flush.FlushManager;
import org.apache.iotdb.db.engine.storagegroup.StorageGroupInfo;
import org.apache.iotdb.db.engine.storagegroup.TsFileProcessor;
import org.apache.iotdb.db.exception.WriteProcessRejectException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SystemInfo {
    private static final IoTDBConfig config = IoTDBDescriptor.getInstance().getConfig();
    private static final Logger logger = LoggerFactory.getLogger(SystemInfo.class);
    private long totalStorageGroupMemCost = 0L;
    private volatile boolean rejected = false;
    private static long memorySizeForWrite = config.getAllocateMemoryForWrite();
    private Map<StorageGroupInfo, Long> reportedStorageGroupMemCostMap = new HashMap<StorageGroupInfo, Long>();
    private long flushingMemTablesCost = 0L;
    private ExecutorService flushTaskSubmitThreadPool = IoTDBThreadPoolFactory.newSingleThreadExecutor((String)"FlushTask-Submit-Pool");
    private static double FLUSH_THERSHOLD = (double)memorySizeForWrite * config.getFlushProportion();
    private static double REJECT_THERSHOLD = (double)memorySizeForWrite * config.getRejectProportion();
    private volatile boolean isEncodingFasterThanIo = true;

    public synchronized boolean reportStorageGroupStatus(StorageGroupInfo storageGroupInfo, TsFileProcessor tsFileProcessor) throws WriteProcessRejectException {
        long delta = storageGroupInfo.getMemCost() - this.reportedStorageGroupMemCostMap.getOrDefault(storageGroupInfo, 0L);
        this.totalStorageGroupMemCost += delta;
        if (logger.isDebugEnabled()) {
            logger.debug("Report Storage Group Status to the system. After adding {}, current sg mem cost is {}.", (Object)delta, (Object)this.totalStorageGroupMemCost);
        }
        this.reportedStorageGroupMemCostMap.put(storageGroupInfo, storageGroupInfo.getMemCost());
        storageGroupInfo.setLastReportedSize(storageGroupInfo.getMemCost());
        if ((double)this.totalStorageGroupMemCost < FLUSH_THERSHOLD) {
            return true;
        }
        if ((double)this.totalStorageGroupMemCost >= FLUSH_THERSHOLD && (double)this.totalStorageGroupMemCost < REJECT_THERSHOLD) {
            logger.debug("The total storage group mem costs are too large, call for flushing. Current sg cost is {}", (Object)this.totalStorageGroupMemCost);
            this.chooseMemTablesToMarkFlush(tsFileProcessor);
            return true;
        }
        logger.info("Change system to reject status. Triggered by: logical SG ({}), mem cost delta ({}), totalSgMemCost ({}).", new Object[]{storageGroupInfo.getDataRegion().getLogicalStorageGroupName(), delta, this.totalStorageGroupMemCost});
        this.rejected = true;
        if (this.chooseMemTablesToMarkFlush(tsFileProcessor)) {
            if (this.totalStorageGroupMemCost < memorySizeForWrite) {
                return true;
            }
            throw new WriteProcessRejectException("Total Storage Group MemCost " + this.totalStorageGroupMemCost + " is over than memorySizeForWriting " + memorySizeForWrite);
        }
        return false;
    }

    public synchronized void resetStorageGroupStatus(StorageGroupInfo storageGroupInfo) {
        long delta = 0L;
        if (this.reportedStorageGroupMemCostMap.containsKey(storageGroupInfo)) {
            delta = this.reportedStorageGroupMemCostMap.get(storageGroupInfo) - storageGroupInfo.getMemCost();
            this.totalStorageGroupMemCost -= delta;
            storageGroupInfo.setLastReportedSize(storageGroupInfo.getMemCost());
            this.reportedStorageGroupMemCostMap.put(storageGroupInfo, storageGroupInfo.getMemCost());
        }
        if ((double)this.totalStorageGroupMemCost >= FLUSH_THERSHOLD && (double)this.totalStorageGroupMemCost < REJECT_THERSHOLD) {
            logger.debug("SG ({}) released memory (delta: {}) but still exceeding flush proportion (totalSgMemCost: {}), call flush.", new Object[]{storageGroupInfo.getDataRegion().getLogicalStorageGroupName(), delta, this.totalStorageGroupMemCost});
            if (this.rejected) {
                logger.info("SG ({}) released memory (delta: {}), set system to normal status (totalSgMemCost: {}).", new Object[]{storageGroupInfo.getDataRegion().getLogicalStorageGroupName(), delta, this.totalStorageGroupMemCost});
            }
            this.logCurrentTotalSGMemory();
            this.rejected = false;
        } else if ((double)this.totalStorageGroupMemCost >= REJECT_THERSHOLD) {
            logger.warn("SG ({}) released memory (delta: {}), but system is still in reject status (totalSgMemCost: {}).", new Object[]{storageGroupInfo.getDataRegion().getLogicalStorageGroupName(), delta, this.totalStorageGroupMemCost});
            this.logCurrentTotalSGMemory();
            this.rejected = true;
        } else {
            logger.debug("SG ({}) released memory (delta: {}), system is in normal status (totalSgMemCost: {}).", new Object[]{storageGroupInfo.getDataRegion().getLogicalStorageGroupName(), delta, this.totalStorageGroupMemCost});
            this.logCurrentTotalSGMemory();
            this.rejected = false;
        }
    }

    public synchronized void addFlushingMemTableCost(long flushingMemTableCost) {
        this.flushingMemTablesCost += flushingMemTableCost;
    }

    public synchronized void resetFlushingMemTableCost(long flushingMemTableCost) {
        this.flushingMemTablesCost -= flushingMemTableCost;
    }

    private void logCurrentTotalSGMemory() {
        logger.debug("Current Sg cost is {}", (Object)this.totalStorageGroupMemCost);
    }

    private boolean chooseMemTablesToMarkFlush(TsFileProcessor currentTsFileProcessor) {
        if (this.reportedStorageGroupMemCostMap.size() == 0) {
            return false;
        }
        PriorityQueue<TsFileProcessor> allTsFileProcessors = new PriorityQueue<TsFileProcessor>((o1, o2) -> Long.compare(o2.getWorkMemTableRamCost(), o1.getWorkMemTableRamCost()));
        for (StorageGroupInfo storageGroupInfo : this.reportedStorageGroupMemCostMap.keySet()) {
            allTsFileProcessors.addAll(storageGroupInfo.getAllReportedTsp());
        }
        boolean isCurrentTsFileProcessorSelected = false;
        long memCost = 0L;
        long activeMemSize = this.totalStorageGroupMemCost - this.flushingMemTablesCost;
        while ((double)(activeMemSize - memCost) > FLUSH_THERSHOLD) {
            if (allTsFileProcessors.isEmpty() || ((TsFileProcessor)allTsFileProcessors.peek()).getWorkMemTableRamCost() == 0L) {
                return false;
            }
            TsFileProcessor selectedTsFileProcessor = (TsFileProcessor)allTsFileProcessors.peek();
            memCost += selectedTsFileProcessor.getWorkMemTableRamCost();
            selectedTsFileProcessor.setWorkMemTableShouldFlush();
            this.flushTaskSubmitThreadPool.submit(() -> selectedTsFileProcessor.submitAFlushTask());
            if (selectedTsFileProcessor == currentTsFileProcessor) {
                isCurrentTsFileProcessorSelected = true;
            }
            allTsFileProcessors.poll();
        }
        return isCurrentTsFileProcessorSelected;
    }

    public boolean isRejected() {
        return this.rejected;
    }

    public void setEncodingFasterThanIo(boolean isEncodingFasterThanIo) {
        this.isEncodingFasterThanIo = isEncodingFasterThanIo;
    }

    public boolean isEncodingFasterThanIo() {
        return this.isEncodingFasterThanIo;
    }

    public void close() {
        this.reportedStorageGroupMemCostMap.clear();
        this.totalStorageGroupMemCost = 0L;
        this.rejected = false;
    }

    public static SystemInfo getInstance() {
        return InstanceHolder.instance;
    }

    public synchronized void applyTemporaryMemoryForFlushing(long estimatedTemporaryMemSize) {
        FLUSH_THERSHOLD = (double)(memorySizeForWrite -= estimatedTemporaryMemSize) * config.getFlushProportion();
        REJECT_THERSHOLD = (double)memorySizeForWrite * config.getRejectProportion();
    }

    public synchronized void releaseTemporaryMemoryForFlushing(long estimatedTemporaryMemSize) {
        FLUSH_THERSHOLD = (double)(memorySizeForWrite += estimatedTemporaryMemSize) * config.getFlushProportion();
        REJECT_THERSHOLD = (double)memorySizeForWrite * config.getRejectProportion();
    }

    public long getTotalMemTableSize() {
        return this.totalStorageGroupMemCost;
    }

    public double getFlushThershold() {
        return FLUSH_THERSHOLD;
    }

    public double getRejectThershold() {
        return REJECT_THERSHOLD;
    }

    public int flushingMemTableNum() {
        return FlushManager.getInstance().getNumberOfWorkingTasks();
    }

    private static class InstanceHolder {
        private static SystemInfo instance = new SystemInfo();

        private InstanceHolder() {
        }
    }
}

