/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.query.reader.series;

import java.io.IOException;
import java.util.Set;
import org.apache.iotdb.commons.path.PartialPath;
import org.apache.iotdb.db.engine.querycontext.QueryDataSource;
import org.apache.iotdb.db.metadata.path.AlignedPath;
import org.apache.iotdb.db.query.context.QueryContext;
import org.apache.iotdb.db.query.filter.TsFileFilter;
import org.apache.iotdb.db.query.reader.series.AlignedSeriesReader;
import org.apache.iotdb.db.query.reader.series.IAggregateReader;
import org.apache.iotdb.tsfile.file.metadata.enums.TSDataType;
import org.apache.iotdb.tsfile.file.metadata.statistics.Statistics;
import org.apache.iotdb.tsfile.read.common.BatchData;
import org.apache.iotdb.tsfile.read.filter.basic.Filter;

public class AlignedSeriesAggregateReader
implements IAggregateReader {
    private final AlignedSeriesReader seriesReader;
    private int curIndex = 0;
    private final int subSensorSize;

    public AlignedSeriesAggregateReader(AlignedPath seriesPath, Set<String> allSensors, TSDataType dataType, QueryContext context, QueryDataSource dataSource, Filter timeFilter, Filter valueFilter, TsFileFilter fileFilter, boolean ascending) {
        this.seriesReader = new AlignedSeriesReader((PartialPath)seriesPath, allSensors, dataType, context, dataSource, timeFilter, valueFilter, fileFilter, ascending);
        this.subSensorSize = seriesPath.getMeasurementList().size();
    }

    @Override
    public boolean isAscending() {
        return this.seriesReader.getOrderUtils().getAscending();
    }

    @Override
    public boolean hasNextFile() throws IOException {
        return this.seriesReader.hasNextFile();
    }

    @Override
    public boolean canUseCurrentFileStatistics() throws IOException {
        Statistics fileStatistics = this.seriesReader.currentFileTimeStatistics();
        return !this.seriesReader.isFileOverlapped() && this.containedByTimeFilter(fileStatistics) && !this.seriesReader.currentFileModified();
    }

    @Override
    public Statistics currentFileStatistics() throws IOException {
        return this.seriesReader.currentFileStatistics(this.curIndex);
    }

    public Statistics currentFileTimeStatistics() throws IOException {
        return this.seriesReader.currentFileTimeStatistics();
    }

    @Override
    public void skipCurrentFile() {
        this.seriesReader.skipCurrentFile();
    }

    @Override
    public boolean hasNextChunk() throws IOException {
        return this.seriesReader.hasNextChunk();
    }

    @Override
    public boolean canUseCurrentChunkStatistics() throws IOException {
        Statistics chunkStatistics = this.seriesReader.currentChunkTimeStatistics();
        return !this.seriesReader.isChunkOverlapped() && this.containedByTimeFilter(chunkStatistics) && !this.seriesReader.currentChunkModified();
    }

    @Override
    public Statistics currentChunkStatistics() throws IOException {
        return this.seriesReader.currentChunkStatistics(this.curIndex);
    }

    public Statistics currentChunkTimeStatistics() throws IOException {
        return this.seriesReader.currentChunkTimeStatistics();
    }

    @Override
    public void skipCurrentChunk() {
        this.seriesReader.skipCurrentChunk();
    }

    @Override
    public boolean hasNextPage() throws IOException {
        return this.seriesReader.hasNextPage();
    }

    @Override
    public boolean canUseCurrentPageStatistics() throws IOException {
        Statistics currentPageStatistics = this.seriesReader.currentPageTimeStatistics();
        if (currentPageStatistics == null) {
            return false;
        }
        return !this.seriesReader.isPageOverlapped() && this.containedByTimeFilter(currentPageStatistics) && !this.seriesReader.currentPageModified();
    }

    @Override
    public Statistics currentPageStatistics() throws IOException {
        return this.seriesReader.currentPageStatistics(this.curIndex);
    }

    public Statistics currentPageTimeStatistics() throws IOException {
        return this.seriesReader.currentPageTimeStatistics();
    }

    @Override
    public void skipCurrentPage() {
        this.seriesReader.skipCurrentPage();
    }

    @Override
    public BatchData nextPage() throws IOException {
        return this.seriesReader.nextPage().flip();
    }

    private boolean containedByTimeFilter(Statistics statistics) {
        Filter timeFilter = this.seriesReader.getTimeFilter();
        return timeFilter == null || timeFilter.containStartEndTime(statistics.getStartTime(), statistics.getEndTime());
    }

    public boolean hasNextSubSeries() {
        if (this.getCurIndex() < this.subSensorSize) {
            return true;
        }
        this.resetIndex();
        return false;
    }

    public void nextSeries() {
        ++this.curIndex;
    }

    public int getCurIndex() {
        return this.curIndex;
    }

    public void resetIndex() {
        this.curIndex = 0;
    }
}

